/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.blocks.VariantHorizontalRotatableBlock;
import supersymmetry.api.capability.impl.SuSyTurbineRecipeLogic;
import supersymmetry.common.blocks.BlockAlternatorCoil;
import supersymmetry.common.blocks.BlockTurbineRotor;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntitySUSYLargeTurbine
extends FuelMultiblockController
implements ITieredMetaTileEntity {
    public final int tier;
    public final IBlockState casingState;
    public final ICubeRenderer casingRenderer;
    public final ICubeRenderer frontOverlay;

    public MetaTileEntitySUSYLargeTurbine(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier, IBlockState casingState, ICubeRenderer casingRenderer, ICubeRenderer frontOverlay) {
        super(metaTileEntityId, recipeMap, tier);
        this.casingState = casingState;
        this.casingRenderer = casingRenderer;
        this.frontOverlay = frontOverlay;
        this.tier = tier;
        this.recipeMapWorkable = new SuSyTurbineRecipeLogic(this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntitySUSYLargeTurbine(this.metaTileEntityId, this.recipeMap, this.tier, this.casingState, this.casingRenderer, this.frontOverlay);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            FluidStack fuelStack = ((SuSyTurbineRecipeLogic)this.recipeMapWorkable).getInputFluidStack();
            int fuelAmount = fuelStack == null ? 0 : fuelStack.amount;
            TextComponentTranslation fuelName = new TextComponentTranslation(fuelAmount == 0 ? "gregtech.fluid.empty" : fuelStack.getUnlocalizedName(), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.fuel_amount", new Object[]{fuelAmount, fuelName}));
        }
        super.addDisplayText(textList);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casingPredicate = MetaTileEntitySUSYLargeTurbine.states((IBlockState[])new IBlockState[]{MetaTileEntitySUSYLargeTurbine.getCasingState()}).setMinGlobalLimited(52).or(MetaTileEntitySUSYLargeTurbine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setPreviewCount(1));
        TraceabilityPredicate maintenance = MetaTileEntitySUSYLargeTurbine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH}).setMaxGlobalLimited(1);
        return FactoryBlockPattern.start().aisle(new String[]{"GAAAAAAAO", "GAAAAAAAO", "G   A   O"}).aisle(new String[]{"GAAAAAAAO", "GDDDDCCCF", "GAAAAAAAO"}).aisle(new String[]{"GAAAAAAAO", "GSAAAAAAO", "G   A   O"}).where('S', this.selfPredicate()).where('A', casingPredicate.or(this.autoAbilities(false, false, false, false, false, false, false)).or(maintenance)).where('O', casingPredicate.or(this.autoAbilities(false, false, false, false, false, true, false)).or(maintenance)).where('C', this.coilOrientation()).where('D', this.rotorOrientation()).where('F', MetaTileEntitySUSYLargeTurbine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY})).where('G', casingPredicate.or(this.autoAbilities(false, false, false, false, true, false, false)).or(maintenance)).where(' ', MetaTileEntitySUSYLargeTurbine.any()).build();
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING);
    }

    protected TraceabilityPredicate rotorOrientation() {
        EnumFacing leftFacing = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing axialFacing = leftFacing.func_176745_a() < 4 ? EnumFacing.SOUTH : EnumFacing.WEST;
        Supplier<BlockInfo[]> supplier = () -> new BlockInfo[]{new BlockInfo(this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing))};
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            if (!(state.func_177230_c() instanceof BlockTurbineRotor)) {
                return false;
            }
            if (state != this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing)) {
                this.getWorld().func_175656_a(blockWorldState.getPos(), this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing));
            }
            return true;
        }, supplier);
    }

    protected TraceabilityPredicate coilOrientation() {
        EnumFacing leftFacing = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing axialFacing = leftFacing.func_176745_a() < 4 ? EnumFacing.SOUTH : EnumFacing.WEST;
        Supplier<BlockInfo[]> supplier = () -> new BlockInfo[]{new BlockInfo(this.copperCoilState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing))};
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            if (!(state.func_177230_c() instanceof BlockAlternatorCoil)) {
                return false;
            }
            if (state != this.copperCoilState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing)) {
                this.getWorld().func_175656_a(blockWorldState.getPos(), this.copperCoilState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing));
            }
            return true;
        }, supplier);
    }

    protected IBlockState steelRotorState() {
        return SuSyBlocks.TURBINE_ROTOR.getState(BlockTurbineRotor.BlockTurbineRotorType.STEEL);
    }

    protected IBlockState copperCoilState() {
        return SuSyBlocks.ALTERNATOR_COIL.getState(BlockAlternatorCoil.AlternatorCoilType.COPPER);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.casingRenderer;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return this.frontOverlay;
    }

    public boolean hasMufflerMechanics() {
        return false;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean canVoidRecipeItemOutputs() {
        return true;
    }

    public boolean canVoidRecipeFluidOutputs() {
        return true;
    }

    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }
}

