/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import supersymmetry.api.capability.impl.NoEnergyMultiblockRecipeLogic;
import supersymmetry.api.recipes.SuSyRecipeMaps;

public class MetaTileEntityReverberatoryFurnace
extends RecipeMapMultiblockController {
    public MetaTileEntityReverberatoryFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.REVERBERATORY_FURNACE);
        this.recipeMapWorkable = new NoEnergyMultiblockRecipeLogic(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityReverberatoryFurnace(this.metaTileEntityId);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX", "YYY"}).aisle(new String[]{"XXX", "X#X", "X#X", "Y#Y"}).aisle(new String[]{"XXX", "X#X", "X#X", "YYY"}).aisle(new String[]{"XXX", "X#X", "X#X", "YYY"}).aisle(new String[]{"XXX", "X#X", "X#X", "YYY"}).aisle(new String[]{"XXX", "X#X", "X#X", "YYY"}).aisle(new String[]{"XXX", "XSX", "XXX", "YYY"}).where('Y', MetaTileEntityReverberatoryFurnace.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS)})).where('X', MetaTileEntityReverberatoryFurnace.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS)}).or(this.autoAbilities(false, false, true, true, true, true, false))).where('#', MetaTileEntityReverberatoryFurnace.air()).where('S', this.selfPredicate()).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PRIMITIVE_BRICKS;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PRIMITIVE_BLAST_FURNACE_OVERLAY;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public void update() {
        super.update();
        if (this.isActive() && this.getWorld().field_72995_K) {
            BlockPos pos = this.getPos();
            EnumFacing facing = this.getFrontFacing().func_176734_d();
            float xPos = (float)facing.func_82601_c() * 5.0f + (float)pos.func_177958_n() + 0.5f;
            float yPos = (float)facing.func_96559_d() * 0.76f + (float)pos.func_177956_o() + 0.25f;
            float zPos = (float)facing.func_82599_e() * 5.0f + (float)pos.func_177952_p() + 0.5f;
            float ySpd = (float)facing.func_96559_d() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
            this.runMufflerEffect(xPos, yPos, zPos, 0.0f, ySpd, 0.0f);
        }
    }

    private void pollutionParticles() {
    }

    public void randomDisplayTick() {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.func_177958_n() + 0.5f;
            float z = (float)pos.func_177952_p() + 0.5f;
            EnumFacing facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            float y = (float)pos.func_177956_o() + GTValues.RNG.nextFloat() * 0.375f + 0.3f;
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                x = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                z = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getWorld().func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
            this.getWorld().func_175688_a(EnumParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

