/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.materials.SusyMaterials;

public class MetaTileEntityOceanPumper
extends MultiblockWithDisplayBase
implements IControllable {
    private IEnergyContainer energyContainers;
    private IMultipleTankHandler outputTankInventory;
    private int drainRate;
    private int BASE_EU_CONSUMPTION_PER_PUMP = 128;
    private boolean isWorking;
    private boolean isWorkingEnabled = true;

    public MetaTileEntityOceanPumper(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityOceanPumper(this.metaTileEntityId);
    }

    public boolean isMultiblockPartWeatherResistant(@Nonnull IMultiblockPart part) {
        return true;
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorking);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorking = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isWorking = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    private void resetTileAbilities() {
        this.outputTankInventory = new FluidTankList(true, new IFluidTank[0]);
        this.energyContainers = new EnergyContainerList((List)Lists.newArrayList());
    }

    protected void updateFormedValid() {
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        if (this.isActive()) {
            this.setActive(false);
        }
    }

    private void initializeAbilities() {
        List energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.energyContainers = new EnergyContainerList(energyInputs);
        this.outputTankInventory = new FluidTankList(false, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    public void setActive(boolean Value) {
        this.isWorking = Value;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, b -> b.writeBoolean(this.isWorking));
        }
    }

    protected int getEnergyConsumedPerPump() {
        return this.BASE_EU_CONSUMPTION_PER_PUMP * (1 << (GTUtility.getTierByVoltage((long)this.energyContainers.getInputVoltage()) - 1) * 2);
    }

    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = this.getEnergyConsumedPerPump();
        long resultEnergy = this.energyContainers.getEnergyStored() - energyToDrain;
        if (resultEnergy > 0L && resultEnergy <= this.energyContainers.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainers.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    public boolean isInValidLocation() {
        Biome biome = this.getWorld().func_180494_b(this.getPos());
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (this.getPos().func_177956_o() < 70 || this.getPos().func_177956_o() > 75) {
            return false;
        }
        return biomeTypes.contains(BiomeDictionary.Type.WATER);
    }

    public boolean insertFluid(boolean simulate) {
        if (!this.isInValidLocation()) {
            return false;
        }
        int fillamount = (int)Math.min(Integer.MAX_VALUE, 500L * (long)(1 << (GTUtility.getTierByVoltage((long)this.energyContainers.getInputVoltage()) - 1) * 2));
        FluidStack Seawater = SusyMaterials.Seawater.getFluid(fillamount);
        int caninsertamount = this.outputTankInventory.fill(Seawater, false);
        if (!simulate) {
            Seawater.amount = Math.min(fillamount, caninsertamount);
            this.outputTankInventory.fill(Seawater, true);
            this.drainRate = Math.min(fillamount, caninsertamount);
        }
        return fillamount == caninsertamount;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isWorking, this.isWorkingEnabled);
    }

    public void update() {
        boolean isWorkingNow;
        super.update();
        if (this.getWorld().field_72995_K || this.getOffsetTimer() % 20L != 0L || !this.isStructureFormed()) {
            return;
        }
        boolean bl = isWorkingNow = this.energyContainers.getEnergyStored() >= (long)this.getEnergyConsumedPerPump() && this.isWorkingEnabled();
        if (isWorkingNow != this.isWorking) {
            this.setActive(isWorkingNow);
        }
        if (isWorkingNow && this.drainEnergy(true)) {
            this.insertFluid(false);
            this.drainEnergy(false);
        }
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean b) {
        this.isWorkingEnabled = b;
        this.notifyBlockUpdate();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            if (this.energyContainers != null && this.energyContainers.getEnergyCapacity() > 0L) {
                byte energyContainer = GTUtility.getTierByVoltage((long)this.energyContainers.getInputVoltage());
                long maxVoltage = GTValues.V[energyContainer] / 2L;
                String voltageName = GTValues.VNF[energyContainer - 1];
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.max_energy_per_tick", new Object[]{maxVoltage, voltageName}));
            }
            if (this.isActive() && this.drainEnergy(true)) {
                textList.add(new TextComponentTranslation("gregtech.machine.miner.working", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                textList.add((ITextComponent)new TextComponentTranslation("susy.ocean_pumper.drainrate", new Object[]{this.drainRate}));
            } else if (!this.drainEnergy(true)) {
                textList.add(new TextComponentTranslation("gregtech.machine.miner.needspower", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            } else if (!this.isWorkingEnabled()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
            } else if (!this.insertFluid(true)) {
                textList.add(new TextComponentTranslation("susy.ocean_pumper.full", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"FF***********FF", "FF***********FF", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"FF***********FF", "FF***********FF", "*FF*********FF*", "*FF*********FF*", "***************", "*****FFFFF*****", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "*FF*********FF*", "*FF*********FF*", "**FFFFFFFFFFF**", "**FFFFFFFFFFF**", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**FFF*****FFF**", "**FFFFFFFFFFF**", "***FF*****FF***", "***FF*****FF***", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**FF*******FF**", "**FF*******FF**", "***FF*****FF***", "***FF*****FF***", "****FF***FF****", "****FF***FF****", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**F*********F**", "*FFF**CCC**FFF*", "******CCC******", "******CCC******", "****FFCCCFF****", "****FFF*FFF****", "*****F*F*F*****", "*****FF*FF*****", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "*******C*******", "*******C*******", "**F***CCC***F**", "*FFF*CCCCC*FFF*", "*****CPPPC*****", "*****CPPPC*****", "*****CCPCC*****", "*****F*C*F*****", "*******C*******", "*****F*C*F*****", "*******C*******", "*******G*******", "*******G*******", "******GGG******"}).aisle(new String[]{"*******P*******", "*******P*******", "******CPC******", "******CPC******", "**F***CPC***F**", "*FFF*CCPCC*FFF*", "*****CPPPC*****", "*****CPPPC*****", "*****CPPPC*****", "******CPC******", "*****FCPCF*****", "******CPC******", "******CPC******", "******GPG******", "******GPG******", "******GPG******"}).aisle(new String[]{"***************", "***************", "*******C*******", "*******C*******", "**F***CCC***F**", "*FFF*CCCCC*FFF*", "*****CPPPC*****", "*****CPPPC*****", "*****CCPCC*****", "*****F*C*F*****", "*******C*******", "*****F*C*F*****", "*******C*******", "*******G*******", "*******G*******", "******GGG******"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**F*********F**", "*FFF**CCC**FFF*", "******CCC******", "******CSC******", "****FFCCCFF****", "****FFF*FFF****", "*****F*F*F*****", "*****FF*FF*****", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**FF*******FF**", "**FF*******FF**", "***FF*****FF***", "***FF*****FF***", "****FF***FF****", "****FF***FF****", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "***************", "***************", "**FFF*****FFF**", "**FFFFFFFFFFF**", "***FF*****FF***", "***FF*****FF***", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"***************", "***************", "*FF*********FF*", "*FF*********FF*", "**FFFFFFFFFFF**", "**FFFFFFFFFFF**", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"FF***********FF", "FF***********FF", "*FF*********FF*", "*FF*********FF*", "***************", "*****FFFFF*****", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).aisle(new String[]{"FF***********FF", "FF***********FF", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************", "***************"}).where('S', this.selfPredicate()).where('C', MetaTileEntityOceanPumper.states((IBlockState[])new IBlockState[]{MetaTileEntityOceanPumper.getCasingState()}).setMinGlobalLimited(88).or(MetaTileEntityOceanPumper.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS})).or(MetaTileEntityOceanPumper.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY})).or(MetaTileEntityOceanPumper.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH}))).where('P', MetaTileEntityOceanPumper.states((IBlockState[])new IBlockState[]{MetaTileEntityOceanPumper.getPipeCasingState()})).where('F', MetaTileEntityOceanPumper.frames((Material[])new Material[]{Materials.Steel})).where('G', MetaTileEntityOceanPumper.states((IBlockState[])new IBlockState[]{MetaTileEntityOceanPumper.getGrateState()})).where('L', MetaTileEntityOceanPumper.states((IBlockState[])new IBlockState[]{MetaTileEntityOceanPumper.getConcreteState()})).where('*', MetaTileEntityOceanPumper.any()).build();
    }

    public String[] getDescription() {
        return (String[])Stream.of(new String[]{I18n.func_135052_a((String)"gregtech.multiblock.ocean_pumper.description", (Object[])new Object[0])}).flatMap(Stream::of).toArray(String[]::new);
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.OCEANIC_DRILL_OVERLAY;
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    protected static IBlockState getGrateState() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING);
    }

    protected static IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    protected static IBlockState getConcreteState() {
        return ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getState((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT);
    }

    public boolean isActive() {
        return this.isWorking;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }
}

