/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.BiomeProperty;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityLargeFluidPump
extends RecipeMapMultiblockController {
    public MetaTileEntityLargeFluidPump(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.PUMPING_RECIPES);
        this.recipeMapWorkable = new LargePumpRecipeLogic(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeFluidPump(this.metaTileEntityId);
    }

    public boolean isMultiblockPartWeatherResistant(@Nonnull IMultiblockPart part) {
        return true;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{"       ", "      P", "       "}).aisle(new String[]{"       ", "      P", "       "}).aisle(new String[]{"FCCCC  ", "CCCCC P", "FCECC  "}).aisle(new String[]{"CCSGC  ", "OPPPPPP", "CCEGC  "}).aisle(new String[]{"FCCC   ", "CCCCC  ", "FCEC   "}).where(' ', MetaTileEntityLargeFluidPump.any()).where('S', this.selfPredicate()).where('P', MetaTileEntityLargeFluidPump.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeFluidPump.getPipeCasingState()})).where('G', MetaTileEntityLargeFluidPump.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeFluidPump.getGearboxState()})).where('F', MetaTileEntityLargeFluidPump.frames((Material[])new Material[]{Materials.Steel})).where('C', MetaTileEntityLargeFluidPump.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeFluidPump.getCasingState()}).or(MetaTileEntityLargeFluidPump.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setExactLimit(1)).or(this.autoAbilities(true, false))).where('E', MetaTileEntityLargeFluidPump.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeFluidPump.getCasingState()}).or(MetaTileEntityLargeFluidPump.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY})).setMinGlobalLimited(1).setMaxGlobalLimited(2)).where('O', MetaTileEntityLargeFluidPump.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS})).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    protected static IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    protected static IBlockState getGearboxState() {
        return MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STEEL_GEARBOX);
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_fluid_pump.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_fluid_pump.tooltip.2", (Object[])new Object[0]));
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        EnumFacing leftSide = RelativeDirection.LEFT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing backSide = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        BlockPos tempPos = this.getPos().func_177967_a(leftSide, 4).func_177972_a(backSide);
        int yLevel = this.getPos().func_177956_o();
        String biome = this.getWorld().func_180494_b((BlockPos)tempPos).field_76791_y;
        textList.add(new TextComponentTranslation("susy.large_fluid_pump.y_level", new Object[]{yLevel}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        textList.add(new TextComponentTranslation("susy.large_fluid_pump.biome", new Object[]{biome}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.OCEANIC_DRILL_OVERLAY;
    }

    public static class LargePumpRecipeLogic
    extends MultiblockRecipeLogic {
        public LargePumpRecipeLogic(RecipeMapMultiblockController tileEntity) {
            super(tileEntity, true);
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            return this.checkHeightRequirement() && this.checkBiomeRequirement(recipe) && super.checkRecipe(recipe);
        }

        public boolean checkHeightRequirement() {
            return this.getMetaTileEntity().getPos().func_177956_o() == 64;
        }

        public boolean checkBiomeRequirement(@NotNull Recipe recipe) {
            if (!recipe.hasProperty((RecipeProperty)BiomeProperty.getInstance())) {
                return true;
            }
            EnumFacing leftSide = RelativeDirection.LEFT.getRelativeFacing(this.getMetaTileEntity().getFrontFacing(), ((MultiblockControllerBase)this.getMetaTileEntity()).getUpwardsFacing(), ((MultiblockControllerBase)this.getMetaTileEntity()).isFlipped());
            EnumFacing backSide = RelativeDirection.BACK.getRelativeFacing(this.getMetaTileEntity().getFrontFacing(), ((MultiblockControllerBase)this.getMetaTileEntity()).getUpwardsFacing(), ((MultiblockControllerBase)this.getMetaTileEntity()).isFlipped());
            BlockPos tempPos = this.getMetaTileEntity().getPos().func_177967_a(leftSide, 4).func_177972_a(backSide);
            return ((BiomeProperty.BiomePropertyList)recipe.getProperty((RecipeProperty)BiomeProperty.getInstance(), (Object)BiomeProperty.BiomePropertyList.EMPTY_LIST)).checkBiome(this.getMetaTileEntity().getWorld().func_180494_b(tempPos));
        }

        public int getParallelLimit() {
            return 256;
        }
    }
}

