/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.blocks.VariantHorizontalRotatableBlock;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.common.blocks.BlockSeparatorRotor;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntityGravitySeparator
extends RecipeMapMultiblockController {
    public MetaTileEntityGravitySeparator(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.GRAVITY_SEPARATOR_RECIPES);
        this.recipeMapWorkable = new MultiblockRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityGravitySeparator(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casingPredicate = MetaTileEntityGravitySeparator.states((IBlockState[])new IBlockState[]{MetaTileEntityGravitySeparator.getCasingState()}).setMinGlobalLimited(90);
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.FRONT).aisle(new String[]{"C   C", "CC CC", "CFCFC", "CCSCC", " CCC ", " CCC ", "     "}).aisle(new String[]{"     ", " OOO ", "C###C", "RRRRR", "C###C", "C   C", "     "}).aisle(new String[]{"C   C", "C   C", "MCCCM", "C###C", "RRRRR", "C   C", "     "}).aisle(new String[]{"C   C", "C   C", "ECCCE", "RRRRR", "C###C", "C###C", "     "}).aisle(new String[]{"     ", "     ", "C   C", "CCCCC", "RRRRR", "C###C", "C###C"}).aisle(new String[]{"     ", "C   C", "C   C", " CCC ", "C###C", "RRRRR", "J###J"}).aisle(new String[]{"C   C", "CC CC", "CCCCC", " CCC ", " CCC ", "CCCCC", "CIIIC"}).where('S', this.selfPredicate()).where('R', this.rotorOrientation()).where('C', casingPredicate).where('M', casingPredicate.or(this.autoAbilities(true, false))).where('E', casingPredicate.or(this.autoAbilities(true, false, false, false, false, false, false))).where('I', casingPredicate.or(this.autoAbilities(false, false, true, false, false, false, false))).where('O', casingPredicate.or(this.autoAbilities(false, false, false, true, false, false, false))).where('J', casingPredicate.or(this.autoAbilities(false, false, false, false, true, false, false))).where('F', casingPredicate.or(this.autoAbilities(false, false, false, false, false, true, false))).where('#', MetaTileEntityGravitySeparator.air()).where(' ', MetaTileEntityGravitySeparator.any()).build();
    }

    protected TraceabilityPredicate rotorOrientation() {
        EnumFacing leftFacing = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing axialFacing = leftFacing.func_176745_a() < 4 ? EnumFacing.SOUTH : EnumFacing.WEST;
        Supplier<BlockInfo[]> supplier = () -> new BlockInfo[]{new BlockInfo(this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing))};
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            if (!(state.func_177230_c() instanceof BlockSeparatorRotor)) {
                return false;
            }
            if (state != this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing)) {
                this.getWorld().func_175656_a(blockWorldState.getPos(), this.steelRotorState().func_177226_a((IProperty)VariantHorizontalRotatableBlock.FACING, (Comparable)axialFacing));
            }
            return true;
        }, supplier);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected IBlockState steelRotorState() {
        return SuSyBlocks.SEPARATOR_ROTOR.getState(BlockSeparatorRotor.BlockSeparatorRotorType.STEEL);
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.BLAST_FURNACE_OVERLAY;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }
}

