/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.fluids.FluidState;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMufflerHatch;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.metatileentities.multi.VoidingMultiblockBase;

public class MetaTileEntityFlareStack
extends VoidingMultiblockBase {
    private int height = 5;

    public MetaTileEntityFlareStack(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFlareStack(this.metaTileEntityId);
    }

    @Override
    public boolean canVoidState(FluidState state) {
        boolean bl;
        switch (state) {
            case GAS: 
            case LIQUID: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean incinerate() {
        return true;
    }

    protected BlockPattern createStructurePattern() {
        IBlockState[] iBlockStateArray = new IBlockState[1];
        iBlockStateArray[0] = this.getFireboxCasingState();
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{"S"}).aisle(new String[]{"P"}).setRepeatable(3, 7).aisle(new String[]{"F"}).where('S', this.selfPredicate()).where('P', MetaTileEntityFlareStack.states((IBlockState[])iBlockStateArray).or(MetaTileEntityFlareStack.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setExactLimit(1))).where('F', MetaTileEntityFlareStack.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH}).setExactLimit(1)).build();
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.updateHeight();
    }

    public void setUpwardsFacing(EnumFacing upwardsFacing) {
        super.setUpwardsFacing(upwardsFacing);
        this.updateHeight();
    }

    public void updateHeight() {
        int height;
        World world = this.getWorld();
        if (world == null) {
            return;
        }
        EnumFacing relativeUp = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(relativeUp, height - 2));
        for (height = 5; height < 10 && !this.isBlockMuffler(world, (BlockPos)pos.func_189536_c(relativeUp)); ++height) {
        }
        this.height = height;
        this.rateBonus = (int)Math.pow(2.0, height - 5);
        this.writeCustomData(GregtechDataCodes.UPDATE_STRUCTURE_SIZE, buf -> {
            buf.writeInt(this.height);
            buf.writeInt(this.rateBonus);
        });
    }

    public boolean isBlockMuffler(World world, @NotNull BlockPos pos) {
        if (world == null) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTe = (IGregTechTileEntity)tileEntity;
            MetaTileEntity mte = gtTe.getMetaTileEntity();
            return mte instanceof MetaTileEntityMufflerHatch;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_STRUCTURE_SIZE) {
            this.height = buf.readInt();
            this.rateBonus = buf.readInt();
        }
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("height", this.height);
        data.func_74768_a("rateBonus", this.rateBonus);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.height = data.func_74764_b("height") ? data.func_74762_e("height") : this.height;
        this.rateBonus = data.func_74764_b("rateBonus") ? data.func_74762_e("rateBonus") : this.rateBonus;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.height);
        buf.writeInt(this.rateBonus);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.height = buf.readInt();
        this.rateBonus = buf.readInt();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            TextComponentString componentHeight = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.BLUE, (String)String.valueOf(this.height));
            TextComponentString componentRateBonus = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)(this.rateBonus + "x"));
            TextComponentTranslation componentRateBase = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.flare_stack.rate", (Object[])new Object[]{componentRateBonus});
            TextComponentTranslation componentRateHover = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.flare_stack.rate_hover", (Object[])new Object[0]);
            textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.flare_stack.height", (Object[])new Object[]{componentHeight}));
            textList.add(TextComponentUtil.setHover((ITextComponent)componentRateBase, (ITextComponent[])new ITextComponent[]{componentRateHover}));
        }
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.flare_stack.tooltip.1", (Object[])new Object[]{this.getBaseVoidingRate()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.flare_stack.tooltip.2", (Object[])new Object[0]));
        super.addInformation(stack, world, tooltip, advanced);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected static IBlockState getFireboxCasingState() {
        return MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX);
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.FLARE_STACK_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }
}

