/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.fluids.FluidState;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.metatileentities.multi.VoidingMultiblockBase;

public class MetaTileEntityDumper
extends VoidingMultiblockBase {
    public MetaTileEntityDumper(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.fluidCache.put((Object)FluidRegistry.WATER, true);
        this.fluidCache.put((Object)FluidRegistry.LAVA, true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDumper(this.metaTileEntityId);
    }

    @Override
    public boolean canVoidState(FluidState state) {
        return state == FluidState.LIQUID;
    }

    @Override
    public int getBaseVoidingRate() {
        return 16000;
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"A  A", "BBBB", "A  A"}).aisle(new String[]{"BBBB", "C##A", "BBBB"}).aisle(new String[]{"A  A", "BSBB", "A  A"}).where('S', this.selfPredicate()).where('A', MetaTileEntityDumper.frames((Material[])new Material[]{Materials.Steel})).where('B', MetaTileEntityDumper.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID)})).where('C', MetaTileEntityDumper.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setExactLimit(1)).where(' ', MetaTileEntityDumper.any()).where('#', MetaTileEntityDumper.air()).build();
    }

    public void update() {
        super.update();
        if (this.isActive() && this.getWorld().field_72995_K) {
            this.dumpingParticles();
        }
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            TextComponentString componentRate = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)(this.getBaseVoidingRate() + " L/10t"));
            textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.dumper.rate", (Object[])new Object[]{componentRate}));
        }
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.dumper.tooltip.1", (Object[])new Object[]{this.getBaseVoidingRate()}));
        super.addInformation(stack, world, tooltip, advanced);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
    }

    @SideOnly(value=Side.CLIENT)
    private void dumpingParticles() {
        BlockPos pos = this.getPos();
        EnumFacing facing = this.getFrontFacing().func_176734_d();
        float xPos = (float)pos.func_177958_n() + 1.5f * (float)facing.func_82601_c() + 3.0f * (float)(-facing.func_82599_e());
        float yPos = pos.func_177956_o();
        float zPos = (float)pos.func_177952_p() + 3.0f * (float)facing.func_82601_c() + 1.5f * (float)facing.func_82599_e();
        float ySpd = 0.0f;
        float xSpd = (float)facing.func_82599_e() * 1.0f;
        float zSpd = (float)(-facing.func_82601_c()) * 1.0f;
        this.getWorld().func_175688_a(EnumParticleTypes.WATER_DROP, (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.DUMPER_OVERLAY;
    }
}

