/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import supersymmetry.api.recipes.SuSyRecipeMaps;

public class MetaTileEntityBlender
extends RecipeMapMultiblockController {
    public MetaTileEntityBlender(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.BLENDER_RECIPES);
        this.recipeMapWorkable = new MultiblockRecipeLogic((RecipeMapMultiblockController)this, true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBlender(this.metaTileEntityId);
    }

    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityBlender.states((IBlockState[])new IBlockState[]{MetaTileEntityBlender.getCasingState()}).setMinGlobalLimited(34);
        TraceabilityPredicate abilities = this.autoAbilities();
        return FactoryBlockPattern.start().aisle(new String[]{" XXX ", " XPX ", " XXX ", "  X  "}).aisle(new String[]{"XXXXX", "X D X", "X   X", "  X  "}).aisle(new String[]{"XXXXX", "PDDDP", "X E X", "XXCXX"}).aisle(new String[]{"XXXXX", "X D X", "X   X", "  X  "}).aisle(new String[]{" XXX ", " XSX ", " XXX ", "  X  "}).where('S', this.selfPredicate()).where('X', casing.or(abilities)).where('P', MetaTileEntityBlender.states((IBlockState[])new IBlockState[]{MetaTileEntityBlender.getPipeCasingState()})).where('D', MetaTileEntityBlender.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN)})).where('E', MetaTileEntityBlender.frames((Material[])new Material[]{Materials.StainlessSteel})).where('C', MetaTileEntityBlender.states((IBlockState[])new IBlockState[]{MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STAINLESS_STEEL_GEARBOX)})).where(' ', MetaTileEntityBlender.any()).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.INERT_PTFE_CASING;
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PTFE_INERT_CASING);
    }

    protected static IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.POLYTETRAFLUOROETHYLENE_PIPE);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.LARGE_CHEMICAL_REACTOR_OVERLAY;
    }
}

