/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.GTFluid;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class VoidingMultiblockBase
extends MultiblockWithDisplayBase {
    public int rateBonus = 1;
    public final int voidingFrequency = 10;
    public boolean active = false;
    public Object2BooleanOpenHashMap<Fluid> fluidCache = new Object2BooleanOpenHashMap();

    public VoidingMultiblockBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    protected void updateFormedValid() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getOffsetTimer() % 10L == 0L) {
            this.active = false;
            for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
                Fluid fluid;
                boolean voidable;
                FluidStack fs = tank.getFluid();
                if (fs == null || !(voidable = ((Boolean)this.fluidCache.computeIfAbsent((Object)(fluid = fs.getFluid()), this::canVoid)).booleanValue())) continue;
                tank.drain(this.getActualVoidingRate(), true);
                this.active = true;
            }
        }
    }

    public boolean canVoid(Fluid fluid) {
        if (fluid instanceof AttributedFluid) {
            AttributedFluid attributedFluid = (AttributedFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (fluid instanceof GTFluid.GTMaterialFluid) {
                GTFluid.GTMaterialFluid gtFluid = (GTFluid.GTMaterialFluid)fluid;
                Material mat = gtFluid.getMaterial();
                return this.canVoidState(state) && !this.incinerate() ^ mat.hasFlag(MaterialFlags.FLAMMABLE);
            }
            return this.canVoidState(state);
        }
        return false;
    }

    public boolean canVoidState(FluidState state) {
        return false;
    }

    private int getActualVoidingRate() {
        return this.rateBonus * this.getBaseVoidingRate();
    }

    public int getBaseVoidingRate() {
        return 1000;
    }

    public boolean incinerate() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.active = this.lastActive;
        }
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.active);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.active = buf.readBoolean();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.active = false;
        this.writeCustomData(GregtechDataCodes.IS_WORKING, buf -> buf.writeBoolean(false));
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }
}

