/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.item.armor;

import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.items.IBreathingArmorLogic;
import supersymmetry.api.util.SuSyUtility;
import supersymmetry.client.renderer.handler.ITextureRegistrar;
import supersymmetry.client.renderer.handler.SimpleBreathingApparatusModel;
import supersymmetry.common.event.DimensionBreathabilityHandler;
import supersymmetry.common.item.SuSyArmorItem;

public class BreathingApparatus
implements IBreathingArmorLogic,
IItemDurabilityManager,
ITextureRegistrar {
    @SideOnly(value=Side.CLIENT)
    protected ModelBiped model;
    protected final EntityEquipmentSlot SLOT;
    private static final double DEFAULT_ABSORPTION = 0.0;

    public BreathingApparatus(EntityEquipmentSlot slot) {
        this.SLOT = slot;
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return this.SLOT;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String string;
        switch (this.SLOT) {
            case HEAD: {
                string = "susy:textures/armor/gas_mask.png";
                break;
            }
            case CHEST: {
                string = "susy:textures/armor/gas_tank.png";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        if (this.model == null) {
            this.model = new SimpleBreathingApparatusModel("gas", armorSlot);
        }
        return this.model;
    }

    @Override
    public boolean mayBreatheWith(ItemStack stack, EntityPlayer player) {
        SuSyArmorItem item;
        IArmorLogic iArmorLogic;
        if (player.field_71093_bK != 10) {
            return false;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        Item item2 = chest.func_77973_b();
        if (item2 instanceof SuSyArmorItem && (iArmorLogic = ((SuSyArmorItem.SuSyArmorMetaValueItem)(item = (SuSyArmorItem)item2).getItem(chest)).getArmorLogic()) instanceof BreathingApparatus) {
            BreathingApparatus tank = (BreathingApparatus)iArmorLogic;
            return tank.getOxygen(chest) > 0.0;
        }
        return false;
    }

    @Override
    public double getDamageAbsorbed(ItemStack stack, EntityPlayer player) {
        SuSyArmorItem item;
        IArmorLogic iArmorLogic;
        if (!DimensionBreathabilityHandler.isInHazardousEnvironment(player)) {
            return -1.0;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        Item item2 = chest.func_77973_b();
        if (item2 instanceof SuSyArmorItem && (iArmorLogic = ((SuSyArmorItem.SuSyArmorMetaValueItem)(item = (SuSyArmorItem)item2).getItem(chest)).getArmorLogic()) instanceof BreathingApparatus) {
            BreathingApparatus tank = (BreathingApparatus)iArmorLogic;
            tank.changeOxygen(chest, -1.0);
            return -1.0;
        }
        return 0.0;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltips) {
        if (this.getEquipmentSlot(stack) == EntityEquipmentSlot.CHEST) {
            int oxygen = (int)this.getOxygen(stack);
            int maxOxygen = (int)this.getMaxOxygen(stack);
            tooltips.add(I18n.func_135052_a((String)"supersymmetry.oxygen", (Object[])new Object[]{oxygen, maxOxygen}));
        }
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (this.SLOT == EntityEquipmentSlot.CHEST) {
            return this.getOxygen(itemStack) / this.getMaxOxygen(itemStack);
        }
        return 1.0;
    }

    double getOxygen(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("oxygen")) {
            stack.func_77978_p().func_74780_a("oxygen", this.getMaxOxygen(stack));
        }
        return stack.func_77978_p().func_74769_h("oxygen");
    }

    double getMaxOxygen(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("maxOxygen")) {
            stack.func_77978_p().func_74780_a("maxOxygen", 1200.0);
        }
        return stack.func_77978_p().func_74769_h("maxOxygen");
    }

    void changeOxygen(ItemStack stack, double oxygenChange) {
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74780_a("oxygen", this.getOxygen(stack) + oxygenChange);
        stack.func_77982_d(compound);
    }

    @Override
    public List<ResourceLocation> getTextureLocations() {
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        switch (this.SLOT) {
            case HEAD: {
                models.add(SuSyUtility.susyId("armor/gas_mask"));
                break;
            }
            case CHEST: {
                models.add(SuSyUtility.susyId("armor/gas_tank"));
            }
        }
        return models;
    }
}

