/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.item.armor;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import supersymmetry.common.item.armor.AdvancedBreathingApparatus;

public class AdvancedBreathingTank
extends AdvancedBreathingApparatus {
    public static final double INFINITE_OXYGEN = -1.0;
    public final double maxOxygen;

    public AdvancedBreathingTank(double hoursOfLife, String name, int tier, double relativeAbsorption, double maxOxygen) {
        super(EntityEquipmentSlot.CHEST, hoursOfLife, name, tier, relativeAbsorption);
        this.maxOxygen = maxOxygen;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> strings) {
        int maxOxygen = (int)this.getMaxOxygen(stack);
        if ((double)maxOxygen == -1.0) {
            strings.add(I18n.func_135052_a((String)"supersymmetry.unlimited_oxygen", (Object[])new Object[0]));
        } else {
            int oxygen = (int)this.getOxygen(stack);
            strings.add(I18n.func_135052_a((String)"supersymmetry.oxygen", (Object[])new Object[]{oxygen, maxOxygen}));
        }
        super.addInformation(stack, strings);
    }

    @Override
    public void changeOxygen(ItemStack stack, double oxygenChange) {
        if (this.getMaxOxygen(stack) == -1.0) {
            return;
        }
        super.changeOxygen(stack, oxygenChange);
    }

    @Override
    public double getOxygen(ItemStack stack) {
        if (this.getMaxOxygen(stack) == -1.0) {
            return 12000.0;
        }
        return super.getOxygen(stack);
    }

    @Override
    double getMaxOxygen(ItemStack stack) {
        return this.maxOxygen;
    }
}

