/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import supersymmetry.common.event.MobHordePlayerData;

public class MobHordeWorldData
extends WorldSavedData
implements Function<UUID, MobHordePlayerData> {
    private static final String DATA_NAME = "susy_InvasionData";
    private final Map<UUID, MobHordePlayerData> playerDataMap = new HashMap<UUID, MobHordePlayerData>();

    public MobHordeWorldData() {
        this(DATA_NAME);
    }

    public MobHordeWorldData(String name) {
        super(name);
    }

    public static MobHordeWorldData get(World world) {
        MapStorage storage = world.func_175693_T();
        if (storage == null) {
            throw new RuntimeException("Null world storage");
        }
        MobHordeWorldData instance = (MobHordeWorldData)storage.func_75742_a(MobHordeWorldData.class, DATA_NAME);
        if (instance == null) {
            instance = new MobHordeWorldData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    @Override
    public MobHordePlayerData apply(UUID uuid) {
        return this.getPlayerData(uuid);
    }

    public MobHordePlayerData getPlayerData(UUID uuid) {
        MobHordePlayerData invasionPlayerData = this.playerDataMap.get(uuid);
        if (invasionPlayerData == null) {
            invasionPlayerData = new MobHordePlayerData(1000);
            this.playerDataMap.put(uuid, invasionPlayerData);
            this.func_76185_a();
        }
        return invasionPlayerData;
    }

    public void func_76184_a(@Nonnull NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("PlayerData", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagEntry = (NBTTagCompound)tagList.func_179238_g(i);
            UUID uuid = UUID.fromString(tagEntry.func_74779_i("UUID"));
            MobHordePlayerData data = new MobHordePlayerData(1000);
            data.deserializeNBT(tagEntry.func_74775_l("Data"));
            this.playerDataMap.put(uuid, data);
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, MobHordePlayerData> entry : this.playerDataMap.entrySet()) {
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74778_a("UUID", entry.getKey().toString());
            tagEntry.func_74782_a("Data", (NBTBase)entry.getValue().serializeNBT());
            tagList.func_74742_a((NBTBase)tagEntry);
        }
        tag.func_74782_a("PlayerData", (NBTBase)tagList);
        return tag;
    }
}

