/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import supersymmetry.api.util.SuSyDamageSources;
import supersymmetry.common.item.SuSyArmorItem;

public final class DimensionBreathabilityHandler {
    private static final Map<Integer, BreathabilityInfo> dimensionBreathabilityMap = new HashMap<Integer, BreathabilityInfo>();
    public static final int BENEATH_ID = 10;
    public static final int NETHER_ID = -1;
    public static final double ABSORB_ALL = -1.0;

    private DimensionBreathabilityHandler() {
    }

    public static void loadConfig() {
        dimensionBreathabilityMap.clear();
        dimensionBreathabilityMap.put(-1, new BreathabilityInfo(SuSyDamageSources.getToxicAtmoDamage(), 2.0));
        dimensionBreathabilityMap.put(10, new BreathabilityInfo(SuSyDamageSources.getSuffocationDamage(), 0.5));
    }

    public static boolean tickAir(EntityPlayer player, FluidStack oxyStack) {
        if (player.func_184812_l_()) {
            return true;
        }
        Optional<IFluidHandlerItem> tank = player.field_71071_by.field_70462_a.stream().map(a -> (IFluidHandlerItem)a.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).filter(Objects::nonNull).filter(a -> {
            FluidStack drain = a.drain(oxyStack, false);
            return drain != null && drain.amount > 0;
        }).findFirst();
        return tank.isPresent();
    }

    public static boolean isInHazardousEnvironment(EntityPlayer player) {
        return dimensionBreathabilityMap.containsKey(player.field_71093_bK);
    }

    public static void tickPlayer(EntityPlayer player) {
        if (DimensionBreathabilityHandler.isInHazardousEnvironment(player)) {
            SuSyArmorItem item;
            Item item2 = player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b();
            if (item2 instanceof SuSyArmorItem && (item = (SuSyArmorItem)item2).isValid(player.func_184582_a(EntityEquipmentSlot.HEAD), player)) {
                double damageAbsorbed = item.getDamageAbsorbed(player.func_184582_a(EntityEquipmentSlot.HEAD), player);
                if (damageAbsorbed != -1.0) {
                    dimensionBreathabilityMap.get(player.field_71093_bK).damagePlayer(player, damageAbsorbed);
                }
                return;
            }
            dimensionBreathabilityMap.get(player.field_71093_bK).damagePlayer(player);
        }
    }

    public static final class BreathabilityInfo {
        public DamageSource damageType;
        public double defaultDamage;

        public BreathabilityInfo(DamageSource damageType, double defaultDamage) {
            this.damageType = damageType;
            this.defaultDamage = defaultDamage;
        }

        public void damagePlayer(EntityPlayer player) {
            player.func_70097_a(this.damageType, (float)this.defaultDamage);
        }

        public void damagePlayer(EntityPlayer player, double amountAbsorbed) {
            if (this.defaultDamage > amountAbsorbed) {
                player.func_70097_a(this.damageType, (float)this.defaultDamage - (float)amountAbsorbed);
            }
        }
    }
}

