/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.entities;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.physics.Simulation;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.inventory.FilteredStackHandler;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import java.util.ArrayList;
import java.util.List;
import supersymmetry.common.item.SuSyMetaItems;
import supersymmetry.integration.immersiverailroading.control.TunnelBoreControl;
import supersymmetry.integration.immersiverailroading.gui.SuSyIRGUITypes;

public class EntityTunnelBore
extends Locomotive {
    @TagField(value="borerAngle")
    @TagSync
    private float borerAngle = 0.0f;
    private int euT = 30;
    private boolean hasGTElectricalPower = false;
    private final int trackLength = 10;
    private ArrayList<TunnelBoreControl> controlSequence = new ArrayList();

    public FluidQuantity getTankCapacity() {
        return FluidQuantity.ZERO;
    }

    public List<Fluid> getFluidFilter() {
        return new ArrayList<Fluid>();
    }

    public int getBatterySlots() {
        return 4;
    }

    public int getTrackSlots() {
        return 12;
    }

    public int getInventoryWidth() {
        return 9;
    }

    public boolean providesElectricalPower() {
        return false;
    }

    public double getAppliedTractiveEffort(Speed speed) {
        double maxPower_W = (double)this.getDefinition().getHorsePower(this.gauge) * 745.7;
        double efficiency = 0.82;
        double speed_M_S = Math.abs(speed.metric()) / 3.6;
        double maxPowerAtSpeed = this.hasGTElectricalPower ? maxPower_W * efficiency / Math.max(0.001, speed_M_S) : 0.0;
        return maxPowerAtSpeed * (double)this.getThrottle() * (double)this.getReverser();
    }

    public long getElectricalPowerConsumption() {
        return (long)(this.getThrottle() * (float)this.euT);
    }

    public int getInventorySize() {
        return 36 + this.getBatterySlots() + this.getTrackSlots();
    }

    private boolean isNonEmptyBattery(ItemStack is) {
        net.minecraft.item.ItemStack internal = is.internal;
        IElectricItem electricItem = (IElectricItem)internal.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return electricItem != null && electricItem.canProvideChargeExternally() && electricItem.getCharge() > 0L;
    }

    protected void initContainerFilter() {
        int i;
        this.cargoItems.filter.clear();
        SlotFilter filter = stack -> stack.is(this.getRailBedFill());
        ItemStack trackSegmentStack = new ItemStack(SuSyMetaItems.TRACK_SEGMENT.getStackForm());
        SlotFilter trackSegmentFilter = stack -> stack.is(trackSegmentStack);
        this.cargoItems.defaultFilter = filter;
        for (i = 0; i < this.getBatterySlots(); ++i) {
            this.cargoItems.filter.put(i, this::isNonEmptyBattery);
        }
        for (i = this.getBatterySlots(); i < this.getBatterySlots() + this.getTrackSlots(); ++i) {
            this.cargoItems.filter.put(i, trackSegmentFilter);
        }
    }

    public boolean openGui(Player player) {
        if (player.hasPermission(Permissions.LOCOMOTIVE_CONTROL)) {
            SuSyIRGUITypes.TUNNEL_BORE.open(player, (Entity)this);
        }
        return true;
    }

    private List<IElectricItem> getNonEmptyBatteries() {
        FilteredStackHandler inventory = this.cargoItems;
        ArrayList<IElectricItem> batteries = new ArrayList<IElectricItem>();
        for (int i = 0; i < this.getBatterySlots(); ++i) {
            net.minecraft.item.ItemStack batteryStack = inventory.get((int)i).internal;
            IElectricItem electricItem = (IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null || !electricItem.canProvideChargeExternally() || electricItem.getCharge() <= 0L) continue;
            batteries.add(electricItem);
        }
        return batteries;
    }

    public void onTick() {
        super.onTick();
        if (!this.isBuilt()) {
            return;
        }
        this.updateBorer();
        if (!this.getWorld().isClient) {
            Vec3d positionFront;
            ITrack trackFront;
            SimulationState currentState;
            int idx;
            SimulationState nextState;
            long discharged = 0L;
            long consumption = this.getElectricalPowerConsumption();
            this.hasGTElectricalPower = false;
            List<IElectricItem> electricItems = this.getNonEmptyBatteries();
            for (IElectricItem electricItem : electricItems) {
                if ((discharged += electricItem.discharge(consumption - discharged, 20, false, true, false)) < consumption) continue;
                this.hasGTElectricalPower = true;
            }
            if (this.getRotationYaw() % 90.0f != 0.0f) {
                return;
            }
            if (!this.states.isEmpty() && (nextState = (SimulationState)this.states.get((idx = this.states.indexOf(currentState = this.getCurrentState())) + 1)) != null && (trackFront = MovementTrack.findTrack((World)nextState.config.world, (Vec3d)(positionFront = VecUtil.fromWrongYawPitch((float)nextState.config.offsetFront, (float)nextState.yaw, (float)nextState.pitch).add(nextState.position)), (float)nextState.yawFront, (double)nextState.config.gauge.value())) == null) {
                this.placeTrack();
            }
        }
    }

    public void updateBorer() {
        this.borerAngle = (float)((double)this.borerAngle + 18.0 * this.getBorerVelocity());
        this.borerAngle %= 360.0f;
    }

    public double getBorerVelocity() {
        return this.getThrottle() / 5.0f;
    }

    public float getBorerAngle() {
        return this.borerAngle;
    }

    ItemStack getRailBedFill() {
        return new ItemStack(((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getItemVariant((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT));
    }

    public int getAmountInInventory(ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < this.cargoItems.getSlotCount(); ++i) {
            ItemStack stackInInv = this.cargoItems.get(i);
            if (stack.isEmpty() || !stackInInv.is(stack)) continue;
            amount += stackInInv.getCount();
        }
        return amount;
    }

    public void extractFromCargo(ItemStack stack, int amount) {
        for (int i = this.getBatterySlots() + this.getTrackSlots(); i < this.cargoItems.getSlotCount(); ++i) {
            if (amount <= 0) {
                return;
            }
            ItemStack stackInInv = this.cargoItems.get(i);
            if (stack.isEmpty() || !stackInInv.is(stack)) continue;
            ItemStack extracted = this.cargoItems.extract(i, amount, false);
            amount -= extracted.getCount();
        }
    }

    public void placeTrack() {
        ItemStack trackSegmentStack = new ItemStack(SuSyMetaItems.TRACK_SEGMENT.getStackForm());
        for (int i = this.getBatterySlots(); i < this.getBatterySlots() + this.getTrackSlots(); ++i) {
            ItemStack stack = this.cargoItems.get(i);
            if (stack.isEmpty() || !stack.is(trackSegmentStack)) continue;
            int placeableLength = this.trackLength;
            RailSettings settings = this.getRotationPitch() % 360.0f == 0.0f ? this.getSettingsStraight(placeableLength) : this.getSettingsSlope(placeableLength);
            ItemStack trackBlueprintStack = new ItemStack((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, 0);
            settings.write(trackBlueprintStack);
            Facing facing = Facing.fromAngle((float)this.getRotationYaw());
            Vec3i pos = new Vec3i(this.getPosition()).offset(facing);
            float placementAngle = facing.getAngle();
            if (this.getRotationPitch() < 0.0f) {
                pos = pos.offset(facing, 9).down();
                placementAngle = facing.getOpposite().getAngle();
                if (pos.y < 1) {
                    return;
                }
            }
            PlacementInfo placementInfo = new PlacementInfo(trackBlueprintStack, placementAngle, new Vec3d(0.5, 0.5, 0.5));
            RailInfo railInfo = new RailInfo(trackBlueprintStack, placementInfo, null);
            World irWorld = this.getWorld();
            BuilderBase trackBuilder = railInfo.getBuilder(irWorld, pos);
            int cost = trackBuilder.costFill();
            if (this.getAmountInInventory(this.getRailBedFill()) < cost) {
                return;
            }
            ArrayList<ItemStack> trackSegments = new ArrayList<ItemStack>();
            trackSegments.add(trackSegmentStack);
            trackBuilder.setDrops(trackSegments);
            trackBuilder.build();
            Simulation.forceQuickUpdates = true;
            this.states = new ArrayList();
            this.cargoItems.extract(i, 1, false);
            this.extractFromCargo(this.getRailBedFill(), cost);
            return;
        }
    }

    public RailSettings getSettingsStraight(int length) {
        return new RailSettings(this.gauge, "immersiverailroading:track/bmtrack.json", TrackItems.STRAIGHT, length, 90.0f, 1.0f, TrackPositionType.FIXED, TrackSmoothing.BOTH, TrackDirection.NONE, ItemStack.EMPTY, this.getRailBedFill(), false, false);
    }

    public RailSettings getSettingsSlope(int length) {
        return new RailSettings(this.gauge, "immersiverailroading:track/bmtrack.json", TrackItems.SLOPE, length, 90.0f, 1.0f, TrackPositionType.FIXED, TrackSmoothing.BOTH, TrackDirection.NONE, ItemStack.EMPTY, this.getRailBedFill(), false, false);
    }
}

