/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.entities;

import gregtech.api.GTValues;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import supersymmetry.client.audio.MovingSoundDropPod;
import supersymmetry.client.renderer.particles.SusyParticleFlame;
import supersymmetry.client.renderer.particles.SusyParticleSmoke;

public class EntityDropPod
extends EntityLiving
implements IAnimatable {
    private static final DataParameter<Boolean> HAS_LANDED = EntityDataManager.func_187226_a(EntityDropPod.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIME_SINCE_LANDING = EntityDataManager.func_187226_a(EntityDropPod.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_SPAWN = EntityDataManager.func_187226_a(EntityDropPod.class, (DataSerializer)DataSerializers.field_187192_b);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @SideOnly(value=Side.CLIENT)
    private MovingSoundDropPod soundDropPod;

    public EntityDropPod(World worldIn) {
        super(worldIn);
        this.field_70725_aQ = 0;
    }

    public EntityDropPod(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.func_174826_a(new AxisAlignedBB(x - 0.5, y, z - 0.5, x + 0.5, y + 2.0, z + 0.5));
    }

    public EntityDropPod(World worldIn, BlockPos pos) {
        this(worldIn, (float)pos.func_177958_n() - 0.5f, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public boolean canPlayerDismount() {
        return this.field_70128_L || this.getTimeSinceLanding() >= 30;
    }

    public boolean hasLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_LANDED);
    }

    public void setLanded(boolean landed) {
        this.field_70180_af.func_187227_b(HAS_LANDED, (Object)landed);
    }

    public int getTimeSinceLanding() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_LANDING);
    }

    private void setTimeSinceLanding(int timeSinceLanding) {
        this.field_70180_af.func_187227_b(TIME_SINCE_LANDING, (Object)timeSinceLanding);
    }

    public boolean hasTakenOff() {
        return this.getTimeSinceLanding() > 200;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnFlightParticles(boolean goingUp) {
        if (this.field_70128_L || goingUp && this.getTimeSinceLanding() > 500) {
            return;
        }
        double offset = goingUp ? 0.2 : 0.5;
        SusyParticleFlame flame1 = new SusyParticleFlame(this.field_70170_p, this.field_70165_t + 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v + 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() + 0.2) * 0.08, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.08);
        SusyParticleFlame flame2 = new SusyParticleFlame(this.field_70170_p, this.field_70165_t + 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v - 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() + 0.2) * 0.08, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.08);
        SusyParticleFlame flame3 = new SusyParticleFlame(this.field_70170_p, this.field_70165_t - 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v + 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() - 1.2) * 0.08, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.08);
        SusyParticleFlame flame4 = new SusyParticleFlame(this.field_70170_p, this.field_70165_t - 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v - 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() - 1.2) * 0.08, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.08);
        SusyParticleSmoke smoke1 = new SusyParticleSmoke(this.field_70170_p, this.field_70165_t + 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v + 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() + 0.2) * 0.16, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.16);
        SusyParticleSmoke smoke2 = new SusyParticleSmoke(this.field_70170_p, this.field_70165_t + 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v - 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() + 0.2) * 0.16, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.16);
        SusyParticleSmoke smoke3 = new SusyParticleSmoke(this.field_70170_p, this.field_70165_t - 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v + 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() - 1.2) * 0.16, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.16);
        SusyParticleSmoke smoke4 = new SusyParticleSmoke(this.field_70170_p, this.field_70165_t - 0.8, this.field_70163_u + 0.9 + offset, this.field_70161_v - 0.2, 1.5 * ((double)GTValues.RNG.nextFloat() - 1.2) * 0.16, -1.5, 1.5 * ((double)GTValues.RNG.nextFloat() - 0.5) * 0.16);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke2);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke3);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke4);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flame1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flame2);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flame3);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flame4);
    }

    private void handleCollidedBlocks(boolean above) {
        block0: for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = new BlockPos(this.field_70165_t + (double)i, above ? this.field_70163_u + 2.0 : this.field_70163_u - 1.0, this.field_70161_v + (double)j);
                if (this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) {
                    return;
                }
                if ((double)this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) < 0.3) {
                    this.field_70170_p.func_175698_g(pos);
                    continue;
                }
                if (!above) continue;
                this.explode();
                this.field_70170_p.func_72973_f((Entity)this);
                continue block0;
            }
        }
    }

    private void handleCollidedBlocks() {
        this.handleCollidedBlocks(false);
    }

    public void func_70645_a(@NotNull DamageSource source) {
        super.func_70645_a(source);
        this.explode();
    }

    private void explode() {
        int explosionStrength = 1;
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            explosionStrength = 6;
        }
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionStrength, false, false);
        this.func_70106_y();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_LANDED, (Object)false);
        this.field_70180_af.func_187214_a(TIME_SINCE_LANDING, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_SPAWN, (Object)0);
    }

    public void func_70014_b(@NotNull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("landed", this.hasLanded());
        compound.func_74768_a("time_since_landing", this.getTimeSinceLanding());
    }

    public void func_70037_a(@NotNull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setLanded(compound.func_74767_n("Landed"));
        this.setTimeSinceLanding(compound.func_74762_e("time_since_landing"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.canPlayerDismount()) {
            for (Entity rider : this.func_184182_bu()) {
                rider.func_184210_p();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.9;
            }
            if (!this.hasLanded()) {
                this.handleCollidedBlocks();
                this.func_184188_bt().forEach(e -> {
                    e.field_70143_R = 0.0f;
                });
            }
            this.setLanded(this.hasLanded() || this.field_70122_E);
            if (this.hasLanded()) {
                int posZRounded;
                int posYBeneath;
                int posXRounded;
                IBlockState blockBeneath;
                if (this.getTimeSinceLanding() == 0 && (blockBeneath = this.field_70170_p.func_180495_p(new BlockPos(posXRounded = MathHelper.func_76128_c((double)this.field_70165_t), posYBeneath = MathHelper.func_76128_c((double)(this.field_70163_u - 1.2000000029802322)), posZRounded = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
                    SoundType soundType = blockBeneath.func_177230_c().getSoundType(blockBeneath, this.field_70170_p, new BlockPos(posXRounded, posYBeneath, posZRounded), (Entity)this);
                    this.func_184185_a(soundType.func_185845_c(), soundType.func_185843_a() * 3.0f, soundType.func_185847_b() * 0.2f);
                }
                this.setTimeSinceLanding(this.getTimeSinceLanding() + 1);
                if (this.getTimeSinceLanding() > 1000) {
                    this.func_70106_y();
                }
            }
            if (this.hasTakenOff()) {
                if (this.field_70181_x < 10.0) {
                    if (this.field_70181_x < 1.0) {
                        this.field_70181_x += 0.1;
                    }
                    this.field_70181_x *= 1.1;
                }
                this.handleCollidedBlocks(true);
                this.field_70128_L = this.field_70163_u > 300.0;
            }
        } else {
            if (!this.hasLanded()) {
                this.spawnFlightParticles(false);
            }
            if (this.hasTakenOff()) {
                this.spawnFlightParticles(true);
            }
        }
        this.field_70180_af.func_187227_b(TIME_SINCE_SPAWN, (Object)((Integer)this.field_70180_af.func_187225_a(TIME_SINCE_SPAWN) + 1));
        if (this.field_70170_p.field_72995_K && this.soundDropPod != null) {
            if (!this.hasLanded() || this.hasTakenOff()) {
                this.soundDropPod.startPlaying();
            } else {
                this.soundDropPod.stopPlaying();
            }
        }
    }

    protected void func_184225_p(@NotNull Entity passenger) {
        if (this.canPlayerDismount()) {
            super.func_184225_p(passenger);
            if (passenger instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)passenger;
                living.func_94061_f(false);
            }
        }
    }

    public void func_184232_k(@NotNull Entity passenger) {
        super.func_184232_k(passenger);
        float xOffset = MathHelper.func_76126_a((float)(this.field_70761_aq * 0.1f));
        float zOffset = MathHelper.func_76134_b((float)(this.field_70761_aq * 0.1f));
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * xOffset), this.field_70163_u + (double)(this.field_70131_O * 0.2f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * zOffset));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean shouldDismountInWater(@NotNull Entity rider) {
        return false;
    }

    public boolean func_70072_I() {
        return this.func_70090_H();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected boolean func_70692_ba() {
        return this.getTimeSinceLanding() > 1000;
    }

    public boolean func_184652_a(@NotNull EntityPlayer player) {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_70653_a(@NotNull Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public void func_70050_g(int air) {
        super.func_70050_g(300);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getTimeSinceLanding() > 0 && this.getTimeSinceLanding() < 140) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.drop_pod.complete", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_184200_o(Entity passenger) {
        if (this.func_184188_bt().isEmpty()) {
            super.func_184200_o(passenger);
            if (passenger instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)passenger;
                living.func_94061_f(true);
            }
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p.field_72995_K) {
            this.setupDropPodSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupDropPodSound() {
        this.soundDropPod = new MovingSoundDropPod(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundDropPod);
    }
}

