/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.entities;

import gregtech.api.util.GTUtility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import supersymmetry.client.audio.MovingSoundDrone;
import supersymmetry.common.metatileentities.multi.electric.MetaTileEntityDronePad;

public class EntityDrone
extends EntityLiving
implements IAnimatable {
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PAD_ALTITUDE = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DESCENDING_MODE = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_LANDED = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @SideOnly(value=Side.CLIENT)
    private MovingSoundDrone soundDrone;
    private BlockPos padPos;

    public EntityDrone(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_184245_j = -1;
    }

    public EntityDrone(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.func_70105_a(1.0f, 1.0f);
        this.field_184245_j = -1;
        this.func_174826_a(new AxisAlignedBB(x - 1.0, y + 0.0, z - 1.0, x + 1.0, y + 1.0, z + 1.0));
    }

    public EntityDrone(World worldIn, BlockPos pos) {
        this(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177952_p() + 0.5f, (float)pos.func_177952_p() + 0.5f);
    }

    public EntityDrone withPadPos(BlockPos pos) {
        this.padPos = pos;
        return this;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(PAD_ALTITUDE, (Object)0);
        this.field_70180_af.func_187214_a(DESCENDING_MODE, (Object)false);
        this.field_70180_af.func_187214_a(HAS_LANDED, (Object)false);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.padPos != null) {
            MetaTileEntityDronePad pad = (MetaTileEntityDronePad)GTUtility.getMetaTileEntity((IBlockAccess)this.field_70170_p, (BlockPos)this.padPos);
            this.padPos = null;
            if (pad != null) {
                pad.setDrone(null);
            }
        }
    }

    public void onAddedToWorld() {
        MetaTileEntityDronePad pad;
        super.onAddedToWorld();
        if (this.field_70170_p.field_72995_K) {
            this.setupDroneSound();
        }
        if (this.padPos != null && (pad = (MetaTileEntityDronePad)GTUtility.getMetaTileEntity((IBlockAccess)this.field_70170_p, (BlockPos)this.padPos)) != null) {
            pad.setDrone(this);
        }
    }

    public void setRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                this.func_70101_b(90.0f, 0.0f);
                break;
            }
            case SOUTH: {
                this.func_70101_b(180.0f, 0.0f);
                break;
            }
            case WEST: {
                this.func_70101_b(270.0f, 0.0f);
                break;
            }
            default: {
                this.func_70101_b(0.0f, 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupDroneSound() {
        this.soundDrone = new MovingSoundDrone(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundDrone);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184652_a(@NotNull EntityPlayer player) {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_70653_a(@NotNull Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    private void explode() {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true, true);
        this.func_70665_d(DamageSource.field_188406_j, 100.0f);
        this.field_70128_L = true;
    }

    public void setDescendingMode() {
        this.field_70180_af.func_187227_b(DESCENDING_MODE, (Object)true);
    }

    public void setPadAltitude(int y) {
        this.field_70180_af.func_187227_b(PAD_ALTITUDE, (Object)y);
    }

    public void func_70050_g(int air) {
        super.func_70050_g(300);
    }

    public void func_70636_d() {
        super.func_70636_d();
        int age = (Integer)this.field_70180_af.func_187225_a(AGE);
        int padAltitude = (Integer)this.field_70180_af.func_187225_a(PAD_ALTITUDE);
        boolean descendingMode = (Boolean)this.field_70180_af.func_187225_a(DESCENDING_MODE);
        if (!this.field_70170_p.field_72995_K) {
            if (age >= 55 && !descendingMode) {
                this.field_70181_x += 0.125;
                if (age >= 90 && this.isCollidingWithBlocks()) {
                    this.explode();
                }
            } else if (descendingMode) {
                this.field_70181_x = -1.0 * Math.min((this.field_70163_u - (double)padAltitude) * 0.125, 2.0);
                if (this.isCollidingWithBlocks()) {
                    if (this.field_70163_u > (double)(padAltitude + 2) || this.field_70163_u < (double)(padAltitude - 2)) {
                        this.explode();
                    } else if (!((Boolean)this.field_70180_af.func_187225_a(HAS_LANDED)).booleanValue()) {
                        this.setLanded();
                    }
                }
            }
            this.field_70128_L |= this.field_70163_u > 300.0 || age > 255 && !descendingMode;
            if (this.field_70128_L) {
                this.field_70181_x = 0.0;
            }
        } else if (this.soundDrone != null) {
            if (this.field_70148_d) {
                this.soundDrone.startPlaying();
            }
            if (((Boolean)this.field_70180_af.func_187225_a(HAS_LANDED)).booleanValue()) {
                this.soundDrone.stopPlaying();
            }
        }
        this.field_70180_af.func_187227_b(AGE, (Object)(age + 1));
    }

    public boolean isCollidingWithBlocks() {
        return this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos.func_189532_c(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)) != Blocks.field_150350_a.func_176223_P() || this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos.func_189532_c(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)) != Blocks.field_150350_a.func_176223_P();
    }

    public boolean reachedSky() {
        return this.field_70163_u > 256.0 && !this.field_70128_L;
    }

    public void setLanded() {
        this.field_70180_af.func_187227_b(HAS_LANDED, (Object)true);
    }

    public void func_70014_b(@NotNull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Age", ((Integer)this.field_70180_af.func_187225_a(AGE)).intValue());
        compound.func_74768_a("PadAltitude", ((Integer)this.field_70180_af.func_187225_a(PAD_ALTITUDE)).intValue());
        compound.func_74757_a("DescendingMode", ((Boolean)this.field_70180_af.func_187225_a(DESCENDING_MODE)).booleanValue());
        compound.func_74757_a("HasLanded", ((Boolean)this.field_70180_af.func_187225_a(HAS_LANDED)).booleanValue());
        compound.func_74772_a("PadPos", this.padPos.func_177986_g());
    }

    public void func_70037_a(@NotNull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(AGE, (Object)compound.func_74762_e("Age"));
        this.field_70180_af.func_187227_b(PAD_ALTITUDE, (Object)compound.func_74762_e("PadAltitude"));
        this.field_70180_af.func_187227_b(DESCENDING_MODE, (Object)compound.func_74767_n("DescendingMode"));
        this.field_70180_af.func_187227_b(HAS_LANDED, (Object)compound.func_74767_n("HasLanded"));
        this.padPos = BlockPos.func_177969_a((long)compound.func_74763_f("PadPos"));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int age = (Integer)this.field_70180_af.func_187225_a(AGE);
        boolean descendingMode = (Boolean)this.field_70180_af.func_187225_a(DESCENDING_MODE);
        boolean hasLanded = (Boolean)this.field_70180_af.func_187225_a(HAS_LANDED);
        if (age <= 55 && !descendingMode) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.drone.takeoff", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        if ((age >= 55 || descendingMode) && !hasLanded) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.drone.flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        if (hasLanded) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.drone.landing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

