/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.covers;

import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class CoverSteamConveyor
extends CoverConveyor {
    public CoverSteamConveyor(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int itemsPerSecond) {
        super(definition, coverableView, attachedSide, 0, itemsPerSecond);
    }

    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.STEAM_CASING_BRONZE.getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget((Widget)new LabelWidget(10, 5, this.getUITitle(), new Object[0]));
        primaryGroup.addWidget((Widget)new IncrementButtonWidget(136, 20, 30, 20, 1, 8, 64, 512, x$0 -> this.adjustTransferRate(x$0)).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget((Widget)new IncrementButtonWidget(10, 20, 30, 20, -1, -8, -64, -512, x$0 -> this.adjustTransferRate(x$0)).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget((Widget)new ImageWidget(40, 20, 96, 20, (IGuiTexture)GuiTextures.DISPLAY));
        primaryGroup.addWidget((Widget)new TextFieldWidget2(42, 26, 92, 20, () -> String.valueOf(this.getTransferRate()), val -> {
            if (val != null && !val.isEmpty()) {
                this.setTransferRate(MathHelper.func_76125_a((int)Integer.parseInt(val), (int)1, (int)this.maxItemTransferRate));
            }
        }).setNumbersOnly(1, this.maxItemTransferRate).setMaxLength(4).setPostFix("cover.conveyor.transfer_rate"));
        primaryGroup.addWidget((Widget)new CycleButtonWidget(10, 45, 75, 20, CoverConveyor.ConveyorMode.class, () -> ((CoverSteamConveyor)this).getConveyorMode(), arg_0 -> ((CoverSteamConveyor)this).setConveyorMode(arg_0)));
        primaryGroup.addWidget((Widget)new CycleButtonWidget(7, 166, 116, 20, ManualImportExportMode.class, () -> ((CoverSteamConveyor)this).getManualImportExportMode(), x$0 -> this.setManualImportExportMode((ManualImportExportMode)x$0)).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        if (this.getTileEntityHere() instanceof TileEntityItemPipe || this.getNeighbor(this.getAttachedSide()) instanceof TileEntityItemPipe) {
            ImageCycleButtonWidget distributionModeButton = new ImageCycleButtonWidget(149, 166, 20, 20, GuiTextures.DISTRIBUTION_MODE, 3, () -> this.distributionMode.ordinal(), val -> this.setDistributionMode(DistributionMode.values()[val])).setTooltipHoverString(val -> DistributionMode.values()[val].func_176610_l());
            primaryGroup.addWidget((Widget)distributionModeButton);
        }
        this.itemFilterContainer.initUI(70, arg_0 -> ((WidgetGroup)primaryGroup).addWidget(arg_0));
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)176, (int)272).widget((Widget)primaryGroup).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT, 7, 190);
        return this.buildUI(builder, player);
    }

    protected String getUITitle() {
        return "cover.conveyor.steam.title";
    }
}

