/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.command;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.event.MobHordeEvent;
import supersymmetry.common.event.MobHordePlayerData;
import supersymmetry.common.event.MobHordeWorldData;

public class CommandHordeStart
extends CommandBase {
    @NotNull
    public String func_71517_b() {
        return "start";
    }

    @NotNull
    public String func_71518_a(@NotNull ICommandSender sender) {
        return "susy.command.horde.start.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return MobHordeEvent.EVENTS.values().stream().map(event -> event.KEY).collect(Collectors.toList());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (args.length > 0) {
                String name = args[0];
                MobHordeEvent event = MobHordeEvent.EVENTS.get(name);
                MobHordePlayerData playerData = MobHordeWorldData.get(player.field_70170_p).getPlayerData(player.getPersistentID());
                if (event == null) {
                    throw new CommandException("susy.command.horde.start.no_such_horde", new Object[]{name});
                }
                if (!event.canRun(player)) {
                    throw new CommandException("susy.command.horde.start.unable_to_run", new Object[]{name});
                }
                if (playerData.hasActiveInvasion) {
                    if (args.length > 1 && args[1].equals("true")) {
                        playerData.stopInvasion(player);
                    } else {
                        TextComponentTranslation textComponent = new TextComponentTranslation("susy.command.horde.start.has_active_invasion", new Object[]{playerData.currentInvasion});
                        sender.func_145747_a((ITextComponent)textComponent);
                        return;
                    }
                }
                if (!event.run((EntityPlayer)player, playerData::addEntity)) {
                    throw new CommandException("susy.command.horde.start.error_executing_horde", new Object[0]);
                }
                playerData.setCurrentInvasion(event);
                TextComponentTranslation textComponent = new TextComponentTranslation("susy.command.horde.start.started", new Object[]{event.KEY});
                sender.func_145747_a((ITextComponent)textComponent);
            } else {
                throw new CommandException("susy.command.horde.start.argument_required", new Object[0]);
            }
        }
    }
}

