/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.block.VariantBlock;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import org.jetbrains.annotations.NotNull;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.materials.SusyMaterials;

public class SusyStoneVariantBlock
extends VariantBlock<StoneType> {
    private static final PropertyEnum<StoneType> PROPERTY = PropertyEnum.func_177709_a((String)"variant", StoneType.class);
    private final StoneVariant stoneVariant;

    public SusyStoneVariantBlock(@Nonnull StoneVariant stoneVariant) {
        super(Material.field_151576_e);
        this.stoneVariant = stoneVariant;
        this.setRegistryName(stoneVariant.id);
        this.func_149663_c(stoneVariant.translationKey);
        this.func_149711_c(stoneVariant.hardness);
        this.func_149752_b(stoneVariant.resistance);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.getState(StoneType.GABBRO));
        this.func_149647_a((CreativeTabs)GregTechAPI.TAB_GREGTECH_DECORATIONS);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        this.VARIANT = PROPERTY;
        this.VALUES = StoneType.values();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT});
    }

    protected boolean func_149700_E() {
        return this.stoneVariant == StoneVariant.SMOOTH;
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState state, @NotNull Random rand, int fortune) {
        return Item.func_150898_a((Block)(this.stoneVariant == StoneVariant.SMOOTH ? (Block)SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)StoneVariant.COBBLE) : this));
    }

    public double getWalkingSpeed() {
        return this.stoneVariant.walkingSpeed;
    }

    public static enum StoneVariant {
        SMOOTH("susy_stone_smooth"),
        COBBLE("susy_stone_cobble", 2.0f, 10.0f),
        BRICKS("susy_stone_bricks", 0.25);

        public final String id;
        public final String translationKey;
        public final float hardness;
        public final float resistance;
        public final double walkingSpeed;

        private StoneVariant(String id) {
            this(id, id);
        }

        private StoneVariant(String id, double walkingSpeed) {
            this(id, id, 1.5f, 10.0f, walkingSpeed);
        }

        private StoneVariant(String id, String translationKey) {
            this(id, translationKey, 1.5f, 10.0f, 0.0);
        }

        private StoneVariant(String id, float hardness, float resistance) {
            this(id, id, hardness, resistance, 0.0);
        }

        private StoneVariant(String id, String translationKey, float hardness, float resistance, double walkingSpeed) {
            this.id = id;
            this.translationKey = translationKey;
            this.hardness = hardness;
            this.resistance = resistance;
            this.walkingSpeed = walkingSpeed;
        }
    }

    public static enum StoneType implements IStringSerializable
    {
        GABBRO("gabbro", MapColor.field_151670_w),
        GNEISS("gneiss", MapColor.field_193559_aa),
        LIMESTONE("limestone", MapColor.field_193568_T),
        PHYLLITE("phyllite", MapColor.field_151670_w),
        QUARTZITE("quartzite", MapColor.field_151677_p),
        SHALE("shale", MapColor.field_193559_aa),
        SLATE("slate", MapColor.field_193559_aa),
        SOAPSTONE("soapstone", MapColor.field_193568_T),
        KIMBERLITE("kimberlite", MapColor.field_151670_w),
        INDUSTRIAL_CONCRETE("industrial_concrete", MapColor.field_193565_Q);

        private final String name;
        public final MapColor mapColor;

        private StoneType(String name, MapColor mapColor) {
            this.name = name;
            this.mapColor = mapColor;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public OrePrefix getOrePrefix() {
            OrePrefix orePrefix;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GABBRO: 
                case GNEISS: 
                case LIMESTONE: 
                case PHYLLITE: 
                case QUARTZITE: 
                case SHALE: 
                case SLATE: 
                case SOAPSTONE: 
                case KIMBERLITE: {
                    orePrefix = OrePrefix.stone;
                    break;
                }
                case INDUSTRIAL_CONCRETE: {
                    orePrefix = OrePrefix.block;
                }
            }
            return orePrefix;
        }

        public gregtech.api.unification.material.Material getMaterial() {
            gregtech.api.unification.material.Material material;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GABBRO: {
                    material = SusyMaterials.Gabbro;
                    break;
                }
                case GNEISS: {
                    material = SusyMaterials.Gneiss;
                    break;
                }
                case LIMESTONE: {
                    material = SusyMaterials.Limestone;
                    break;
                }
                case PHYLLITE: {
                    material = SusyMaterials.Phyllite;
                    break;
                }
                case QUARTZITE: {
                    material = Materials.Quartzite;
                    break;
                }
                case SHALE: {
                    material = SusyMaterials.Shale;
                    break;
                }
                case SLATE: {
                    material = SusyMaterials.Slate;
                    break;
                }
                case SOAPSTONE: {
                    material = Materials.Soapstone;
                    break;
                }
                case KIMBERLITE: {
                    material = SusyMaterials.Kimberlite;
                    break;
                }
                case INDUSTRIAL_CONCRETE: {
                    material = Materials.Concrete;
                }
            }
            return material;
        }
    }
}

