/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.block.IStateHarvestLevel;
import gregtech.api.block.VariantActiveBlock;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public class BlockElectrodeAssembly
extends VariantActiveBlock<ElectrodeAssemblyType> {
    public BlockElectrodeAssembly() {
        super(Material.field_151573_f);
        this.func_149663_c("electrode_assembly");
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 1);
        this.func_180632_j(this.getState(ElectrodeAssemblyType.CARBON));
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        ElectrodeAssemblyType type = (ElectrodeAssemblyType)this.getState(state);
        if (type == ElectrodeAssemblyType.CARBON ? layer == BlockRenderLayer.SOLID : layer == BlockRenderLayer.CUTOUT) {
            return true;
        }
        if (this.isBloomEnabled(type)) {
            return layer == BloomEffectUtil.getEffectiveBloomLayer();
        }
        return layer == BlockRenderLayer.CUTOUT;
    }

    protected boolean isBloomEnabled(ElectrodeAssemblyType value) {
        return ConfigHolder.client.coilsActiveEmissiveTextures && value == ElectrodeAssemblyType.CARBON;
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public static enum ElectrodeAssemblyType implements IStringSerializable,
    IStateHarvestLevel
    {
        CARBON("carbon", 1);

        private final String name;
        private final int harvestLevel;

        private ElectrodeAssemblyType(String name, int harvestLevel) {
            this.name = name;
            this.harvestLevel = harvestLevel;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getHarvestLevel(IBlockState state) {
            return this.harvestLevel;
        }

        public String getHarvestTool(IBlockState state) {
            return "wrench";
        }
    }
}

