/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common;

import gregtech.api.util.GTTeleporter;
import gregtech.api.util.TeleportHandler;
import gregtech.common.items.MetaItems;
import gregtechfoodoption.item.GTFOMetaItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import supersymmetry.common.entities.EntityDropPod;
import supersymmetry.common.event.DimensionBreathabilityHandler;
import supersymmetry.common.event.MobHordeWorldData;
import supersymmetry.common.item.SuSyArmorItem;

@Mod.EventBusSubscriber(modid="susy")
public class EventHandlers {
    private static final String FIRST_SPAWN = "susy.first_spawn";
    private static boolean cancelFillBucket = false;

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound data;
        NBTTagCompound playerData = event.player.getEntityData();
        NBTTagCompound nBTTagCompound = data = playerData.func_74764_b("PlayerPersisted") ? playerData.func_74775_l("PlayerPersisted") : new NBTTagCompound();
        if (!event.player.func_130014_f_().field_72995_K && !data.func_74767_n(FIRST_SPAWN)) {
            data.func_74757_a(FIRST_SPAWN, true);
            playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
            if (event.player.func_184812_l_()) {
                return;
            }
            EntityDropPod dropPod = new EntityDropPod(event.player.func_130014_f_(), event.player.field_70165_t, event.player.field_70163_u + 256.0, event.player.field_70161_v);
            GTTeleporter teleporter = new GTTeleporter((WorldServer)event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u + 256.0, event.player.field_70161_v);
            TeleportHandler.teleport((Entity)event.player, (int)event.player.field_71093_bK, (ITeleporter)teleporter, (double)event.player.field_70165_t, (double)(event.player.field_70163_u + 256.0), (double)event.player.field_70161_v);
            event.player.func_130014_f_().func_72838_d((Entity)dropPod);
            event.player.func_184220_m((Entity)dropPod);
            event.player.func_191521_c(GTFOMetaItem.EMERGENCY_RATIONS.getStackForm(10));
            event.player.func_191521_c(MetaItems.PROSPECTOR_LV.getChargedStack(100000L));
        }
    }

    @SubscribeEvent
    public static void onTrySpawnPortal(BlockEvent.PortalSpawnEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (world instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            PlayerList list = server.func_73046_m().func_184103_al();
            MobHordeWorldData mobHordeWorldData = MobHordeWorldData.get(world);
            list.func_181057_v().forEach(p -> mobHordeWorldData.getPlayerData(p.getPersistentID()).update((EntityPlayerMP)p));
            mobHordeWorldData.func_76185_a();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.func_82737_E() % 20L == 0L && event.phase == TickEvent.Phase.START) {
            DimensionBreathabilityHandler.tickPlayer(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityLivingFallEventStart(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        Entity armor = event.getEntity();
        if (armor instanceof EntityPlayer && !(boots = (player = (EntityPlayer)armor).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && boots.func_77973_b() instanceof SuSyArmorItem && player.field_70143_R > 3.2f) {
            player.field_70143_R = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        Entity armor = event.getEntity();
        if (armor instanceof EntityPlayer && !(boots = (player = (EntityPlayer)armor).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && boots.func_77973_b() instanceof SuSyArmorItem) {
            player.field_70143_R = event.getDistance();
        }
    }
}

