/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="susy", value={Side.CLIENT})
public class MaterialBlockModelLoader {
    private static final Table<MaterialIconType, MaterialIconSet, ResourceLocation> BLOCKSTATES_CACHE = HashBasedTable.create();
    private static final Object2ObjectOpenHashMap<Entry, ModelResourceLocation> ENTRIES = new Object2ObjectOpenHashMap();

    @Nonnull
    public static ModelResourceLocation loadBlockModel(@Nonnull MaterialIconType iconType, @Nonnull MaterialIconSet iconSet) {
        return MaterialBlockModelLoader.loadBlockModel(iconType, iconSet, null);
    }

    @Nonnull
    public static ModelResourceLocation loadBlockModel(@Nonnull MaterialIconType iconType, @Nonnull MaterialIconSet iconSet, @Nullable String variant) {
        return (ModelResourceLocation)ENTRIES.computeIfAbsent((Object)new Entry(iconType, iconSet, variant == null ? "" : variant), entry -> MaterialBlockModelLoader.createModelId(entry, "normal"));
    }

    @Nonnull
    public static ModelResourceLocation loadItemModel(@Nonnull MaterialIconType iconType, @Nonnull MaterialIconSet iconSet) {
        return (ModelResourceLocation)ENTRIES.computeIfAbsent((Object)new Entry(iconType, iconSet, null), entry -> MaterialBlockModelLoader.createModelId(entry, "inventory"));
    }

    private static ModelResourceLocation createModelId(@Nonnull Entry entry, @Nonnull String variant) {
        StringBuilder stb = new StringBuilder();
        stb.append("material_").append(((Entry)entry).iconType.name).append("_").append(((Entry)entry).iconSet.name);
        if (entry.variant != null && !entry.variant.equals("") && !entry.variant.equals("normal")) {
            stb.append("_").append(entry.variant.replace('=', '_').replace(',', '_'));
        }
        return new ModelResourceLocation(new ResourceLocation("gregtech", stb.toString()), variant);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (Entry e : ENTRIES.keySet()) {
            e.modelCache = MaterialBlockModelLoader.loadModel(event, e);
        }
    }

    @Nullable
    private static IModel loadModel(TextureStitchEvent.Pre event, Entry entry) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)entry.getModelLocation());
        }
        catch (Exception e) {
            GTLog.logger.error("Failed to load material model {}:", (Object)entry, (Object)e);
            return null;
        }
        for (ResourceLocation texture : model.getTextures()) {
            event.getMap().func_174942_a(texture);
        }
        return model;
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map stateModels = Loader.isModLoaded((String)"ctm") ? (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String)"stateModels", null) : null;
        for (Map.Entry e : ENTRIES.entrySet()) {
            MaterialBlockModelLoader.bakeAndRegister((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), ((Entry)e.getKey()).modelCache, (ModelResourceLocation)e.getValue(), stateModels);
        }
    }

    private static void bakeAndRegister(@Nonnull IRegistry<ModelResourceLocation, IBakedModel> registry, @Nullable IModel model, @Nonnull ModelResourceLocation modelId, @Nullable Map<ModelResourceLocation, IModel> stateModels) {
        if (model == null) {
            registry.func_82595_a((Object)modelId, (Object)MaterialBlockModelLoader.bake(ModelLoaderRegistry.getMissingModel()));
            return;
        }
        registry.func_82595_a((Object)modelId, (Object)MaterialBlockModelLoader.bake(model));
        if (stateModels != null) {
            stateModels.put(modelId, model);
        }
    }

    private static IBakedModel bake(IModel model) {
        return model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(t.toString()));
    }

    private static final class Entry {
        private final MaterialIconType iconType;
        private final MaterialIconSet iconSet;
        private final String variant;
        @Nullable
        private IModel modelCache;

        private Entry(@Nonnull MaterialIconType iconType, @Nonnull MaterialIconSet iconSet, @Nullable String variant) {
            this.iconType = iconType;
            this.iconSet = iconSet;
            this.variant = variant;
        }

        public ResourceLocation getModelLocation() {
            if (this.variant != null) {
                return new ModelResourceLocation(this.iconType.recurseIconsetPath(this.iconSet, BLOCKSTATES_CACHE, "blockstates/material_sets/%s/%s.json", "material_sets/%s/%s"), this.variant);
            }
            ResourceLocation itemModelPath = this.iconType.getItemModelPath(this.iconSet);
            return new ResourceLocation(itemModelPath.func_110624_b(), "item/" + itemModelPath.func_110623_a());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.variant, entry.variant) && this.iconType.equals(entry.iconType) && this.iconSet.equals(entry.iconSet);
        }

        public int hashCode() {
            return Objects.hash(this.iconType, this.iconSet, this.variant);
        }

        public String toString() {
            return "Entry{iconType=" + this.iconType + ", iconSet=" + this.iconSet + ", variant=" + this.variant + '}';
        }
    }
}

