/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.util;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.capability.IElytraFlyingProvider;
import supersymmetry.api.capability.SuSyCapabilities;

public class ElytraFlyingUtils {
    public static boolean isElytraFlying(@NotNull EntityLivingBase entity) {
        ItemStack itemstack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (itemstack.hasCapability(SuSyCapabilities.ELYTRA_FLYING_PROVIDER, null)) {
            return ((IElytraFlyingProvider)itemstack.getCapability(SuSyCapabilities.ELYTRA_FLYING_PROVIDER, null)).isElytraFlying(entity, itemstack, entity.field_70122_E || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b || entity.func_184218_aH() || entity.func_70090_H() || ElytraFlyingUtils.isInLavaSafe((Entity)entity));
        }
        return false;
    }

    public static boolean canTakeOff(EntityPlayer player, boolean ignoreOnGround) {
        return (ignoreOnGround || !player.field_70122_E && player.field_70181_x < 0.0) && !player.func_184613_cA() && !player.func_70090_H() && !ElytraFlyingUtils.isInLavaSafe((Entity)player);
    }

    private static boolean isInLavaSafe(@NotNull Entity entity) {
        return ElytraFlyingUtils.isMaterialInBBSafe(entity.field_70170_p, entity.func_174813_aQ().func_72321_a(-0.1, -0.4, -0.1), Material.field_151587_i);
    }

    private static boolean isMaterialInBBSafe(@NotNull World world, @NotNull AxisAlignedBB bb, @NotNull Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    pos.func_181079_c(k1, l1, i2);
                    if (!world.func_175668_a((BlockPos)pos, false) || world.func_180495_p((BlockPos)pos).func_185904_a() != materialIn) continue;
                    pos.func_185344_t();
                    return true;
                }
            }
        }
        pos.func_185344_t();
        return false;
    }
}

