/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.unification.ore;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.ConfigHolder;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import supersymmetry.api.unification.ore.SusyOrePrefix;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.blocks.SusyStoneVariantBlock;
import supersymmetry.common.materials.SusyMaterials;

public class SusyStoneTypes {
    public static StoneType GABBRO;
    public static StoneType GNEISS;
    public static StoneType GRAPHITE;
    public static StoneType LIMESTONE;
    public static StoneType MICA;
    public static StoneType PHYLLITE;
    public static StoneType QUARTZITE;
    public static StoneType SHALE;
    public static StoneType SLATE;
    public static StoneType SOAPSTONE;
    public static StoneType KIMBERLITE;

    public static void init() {
        GABBRO = new StoneType(12, "gabbro", SoundType.field_185851_d, SusyOrePrefix.oreGabbro, SusyMaterials.Gabbro, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.GABBRO), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.GABBRO), false);
        GNEISS = new StoneType(13, "gneiss", SoundType.field_185851_d, SusyOrePrefix.oreGneiss, SusyMaterials.Gneiss, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.GNEISS), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.GNEISS), false);
        LIMESTONE = new StoneType(14, "limestone", SoundType.field_185851_d, SusyOrePrefix.oreLimestone, SusyMaterials.Limestone, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.LIMESTONE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.LIMESTONE), false);
        PHYLLITE = new StoneType(15, "phyllite", SoundType.field_185851_d, SusyOrePrefix.orePhyllite, SusyMaterials.Phyllite, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.PHYLLITE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.PHYLLITE), false);
        QUARTZITE = new StoneType(16, "quartzite", SoundType.field_185851_d, SusyOrePrefix.oreQuartzite, Materials.Quartzite, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.QUARTZITE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.QUARTZITE), false);
        SHALE = new StoneType(17, "shale", SoundType.field_185851_d, SusyOrePrefix.oreShale, SusyMaterials.Shale, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.SHALE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.SHALE), false);
        SLATE = new StoneType(18, "slate", SoundType.field_185851_d, SusyOrePrefix.oreSlate, SusyMaterials.Slate, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.SLATE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.SLATE), false);
        SOAPSTONE = new StoneType(19, "soapstone", SoundType.field_185851_d, SusyOrePrefix.oreSoapstone, Materials.Soapstone, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.SOAPSTONE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.SOAPSTONE), false);
        KIMBERLITE = new StoneType(20, "kimberlite", SoundType.field_185851_d, SusyOrePrefix.oreKimberlite, SusyMaterials.Kimberlite, () -> SusyStoneTypes.gtStoneState(SusyStoneVariantBlock.StoneType.KIMBERLITE), state -> SusyStoneTypes.gtStonePredicate(state, SusyStoneVariantBlock.StoneType.KIMBERLITE), false);
        if (ConfigHolder.worldgen.allUniqueStoneTypes) {
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreGabbro, SusyMaterials.Gabbro);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreGneiss, SusyMaterials.Gneiss);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreLimestone, SusyMaterials.Limestone);
            SusyStoneTypes.addSecondary(SusyOrePrefix.orePhyllite, SusyMaterials.Phyllite);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreQuartzite, Materials.Quartzite);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreShale, SusyMaterials.Shale);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreSlate, SusyMaterials.Slate);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreSoapstone, Materials.Soapstone);
            SusyStoneTypes.addSecondary(SusyOrePrefix.oreKimberlite, SusyMaterials.Kimberlite);
        }
    }

    private static void addSecondary(OrePrefix prefix, Material material) {
        prefix.addSecondaryMaterial(new MaterialStack(material, OrePrefix.dust.getMaterialAmount(material)));
    }

    private static IBlockState gtStoneState(SusyStoneVariantBlock.StoneType stoneType) {
        return SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.SMOOTH).getState(stoneType);
    }

    private static boolean gtStonePredicate(IBlockState state, SusyStoneVariantBlock.StoneType stoneType) {
        SusyStoneVariantBlock block = SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.SMOOTH);
        return state.func_177230_c() == block && block.getState(state) == stoneType;
    }
}

