/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.unification.material.properties;

import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import supersymmetry.api.unification.material.info.SuSyMaterialFlags;

public class FiberProperty
implements IMaterialProperty {
    public boolean solutionSpun;
    private boolean meltSpun;
    private boolean weaving;

    public FiberProperty(boolean solutionSpun, boolean meltSpun, boolean weaving) {
        this.solutionSpun = solutionSpun;
        this.meltSpun = meltSpun;
        this.weaving = weaving;
    }

    public FiberProperty() {
        this(false, true, false);
    }

    public void verifyProperty(MaterialProperties properties) {
        if (properties.hasProperty(PropertyKey.FLUID) && !this.meltSpun) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both a fluid property and is not a melt spun fiber, which is not allowed!");
        }
        if (this.solutionSpun) {
            properties.getMaterial().addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_WET_FIBER});
        }
        if (this.weaving) {
            properties.getMaterial().addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_PLATE});
        }
        properties.getMaterial().addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_FIBER, SuSyMaterialFlags.GENERATE_THREAD, MaterialFlags.DISABLE_DECOMPOSITION});
    }
}

