/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.builders.logic;

import gregtech.api.recipes.logic.OverclockingLogic;
import javax.annotation.Nonnull;
import supersymmetry.api.recipes.catalysts.CatalystInfo;

public final class SuSyOverclockingLogic {
    private SuSyOverclockingLogic() {
    }

    @Nonnull
    public static double[] continuousOverclockingLogic(double recipeEUt, long maxVoltage, double recipeDuration, int numberOfOCs, double durationDivisor, double voltageMultiplier) {
        double potentialVoltage;
        if (numberOfOCs <= 0) {
            return new double[]{recipeEUt, recipeDuration};
        }
        double resultDuration = recipeDuration;
        double resultVoltage = recipeEUt;
        while (numberOfOCs > 0 && !((potentialVoltage = resultVoltage * voltageMultiplier) > (double)maxVoltage)) {
            resultDuration /= durationDivisor;
            resultVoltage = potentialVoltage;
            --numberOfOCs;
        }
        return new double[]{resultVoltage, resultDuration};
    }

    @Nonnull
    public static int[] catalystOverclockingLogic(int recipeEUt, long maximumVoltage, int recipeDuration, int maxOverclocks, @Nonnull CatalystInfo catalystInfo, int recipeRequiredCatalystTier, double durationDivisor, double voltageMultiplier) {
        int amountAboveRecipeTier = catalystInfo.getTier() - recipeRequiredCatalystTier;
        double energyEfficiency = catalystInfo.getEnergyEfficiency();
        double catalystDurationDivisor = catalystInfo.getSpeedEfficiency();
        if (amountAboveRecipeTier > 0) {
            recipeEUt = (int)((double)recipeEUt * Math.min(1.0, Math.pow(energyEfficiency, amountAboveRecipeTier)));
            double resultDurationDouble = (double)recipeDuration / Math.pow(catalystDurationDivisor, amountAboveRecipeTier);
            recipeDuration = resultDurationDouble < 1.0 ? 1 : (int)resultDurationDouble;
            return OverclockingLogic.standardOverclockingLogic((int)recipeEUt, (long)maximumVoltage, (int)recipeDuration, (int)maxOverclocks, (double)durationDivisor, (double)voltageMultiplier);
        }
        return OverclockingLogic.standardOverclockingLogic((int)recipeEUt, (long)maximumVoltage, (int)recipeDuration, (int)maxOverclocks, (double)durationDivisor, (double)voltageMultiplier);
    }

    @Nonnull
    public static double[] continuousCatalystOverclockingLogic(int recipeEUt, long maximumVoltage, int recipeDuration, int maxOverclocks, @Nonnull CatalystInfo catalystInfo, int recipeRequiredCatalystTier, double durationDivisor, double voltageMultiplier) {
        int amountAboveRecipeTier = catalystInfo.getTier() - recipeRequiredCatalystTier;
        double energyEfficiency = catalystInfo.getEnergyEfficiency();
        double catalystDurationDivisor = catalystInfo.getSpeedEfficiency();
        if (amountAboveRecipeTier > 0) {
            recipeEUt = (int)((double)recipeEUt * Math.min(1.0, Math.pow(energyEfficiency, amountAboveRecipeTier)));
            double resultDuration = (double)recipeDuration / Math.pow(catalystDurationDivisor, amountAboveRecipeTier);
            return SuSyOverclockingLogic.continuousOverclockingLogic(recipeEUt, maximumVoltage, resultDuration, maxOverclocks, durationDivisor, voltageMultiplier);
        }
        return SuSyOverclockingLogic.continuousOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, maxOverclocks, durationDivisor, voltageMultiplier);
    }
}

