/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.properties.CoilingCoilTemperatureProperty;

public class CoilingCoilRecipeBuilder
extends RecipeBuilder<CoilingCoilRecipeBuilder> {
    public CoilingCoilRecipeBuilder() {
    }

    public CoilingCoilRecipeBuilder(Recipe recipe, RecipeMap<CoilingCoilRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public CoilingCoilRecipeBuilder(CoilingCoilRecipeBuilder builder) {
        super((RecipeBuilder)builder);
    }

    public CoilingCoilRecipeBuilder copy() {
        return new CoilingCoilRecipeBuilder(this);
    }

    public boolean applyProperty(@NotNull String key, Object value) {
        if (key.equals("cooling_temperature")) {
            this.temperature(((Number)value).intValue());
            return true;
        }
        return super.applyProperty(key, value);
    }

    public CoilingCoilRecipeBuilder temperature(int temperature) {
        if (temperature <= 0) {
            SusyLog.logger.error("Temperature cannot be less than or equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(CoilingCoilTemperatureProperty.getInstance(), temperature);
        return this;
    }

    public int getTemperature() {
        return this.recipePropertyStorage == null ? 0 : (Integer)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)CoilingCoilTemperatureProperty.getInstance(), (Object)0);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(CoilingCoilTemperatureProperty.getInstance().getKey(), this.getTemperature()).toString();
    }
}

