/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.category.GTRecipeCategory;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeMapGroup<R extends RecipeBuilder<R>>
extends RecipeMap<R> {
    protected final RecipeMap<?>[] recipeMaps;

    protected RecipeMapGroup(@NotNull String unlocalizedName, int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs, @NotNull R defaultRecipeBuilder, boolean isHidden, @NotNull RecipeMap<?>[] recipeMaps) {
        super(unlocalizedName, maxInputs, maxOutputs, maxFluidInputs, maxFluidOutputs, defaultRecipeBuilder, isHidden);
        this.recipeMaps = recipeMaps;
    }

    @Nonnull
    public static RecipeMapGroup<SimpleRecipeBuilder> create(@NotNull String unlocalizedName, RecipeMap<?> ... recipeMaps) {
        int maxInputs = 0;
        int maxOutputs = 0;
        int maxFluidInputs = 0;
        int maxFluidOutputs = 0;
        for (RecipeMap<?> recipeMap : recipeMaps) {
            maxInputs = Math.max(maxInputs, recipeMap.getMaxInputs());
            maxOutputs = Math.max(maxOutputs, recipeMap.getMaxOutputs());
            maxFluidInputs = Math.max(maxFluidInputs, recipeMap.getMaxFluidInputs());
            maxFluidOutputs = Math.max(maxFluidOutputs, recipeMap.getMaxFluidOutputs());
        }
        return new RecipeMapGroup<SimpleRecipeBuilder>(unlocalizedName, maxInputs, maxOutputs, maxFluidInputs, maxFluidOutputs, new SimpleRecipeBuilder(), true, recipeMaps);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        AtomicReference recipe = new AtomicReference();
        ((Stream)Arrays.stream(this.recipeMaps).parallel()).map(recipeMap -> recipeMap.findRecipe(voltage, inputs, fluidInputs, exactVoltage)).filter(Objects::nonNull).findFirst().ifPresent(recipe::set);
        return (Recipe)recipe.get();
    }

    @Nonnull
    public Map<GTRecipeCategory, List<Recipe>> getRecipesByCategory() {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        for (RecipeMap<?> recipeMap : this.recipeMaps) {
            res.putAll(recipeMap.getRecipesByCategory());
        }
        return Collections.unmodifiableMap(res);
    }
}

