/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.metatileentity.multiblock;

import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.RelativeDirection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.common.recipes.DistillationTowerRecipeLogic;

public abstract class MetaTileEntityOrderedDT
extends RecipeMapMultiblockController
implements IDistillationTower {
    protected DistillationTowerLogicHandler handler = this.createHandler();

    public MetaTileEntityOrderedDT(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap) {
        super(metaTileEntityId, recipeMap);
        this.recipeMapWorkable = new DistillationTowerRecipeLogic(this);
    }

    @NotNull
    public DistillationTowerLogicHandler createHandler() {
        return new DistillationTowerLogicHandler((IDistillationTower)this);
    }

    public boolean allowSameFluidFillForOutputs() {
        return false;
    }

    public DistillationTowerLogicHandler getHandler() {
        return this.handler;
    }

    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.UP.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.handler == null || this.structurePattern == null) {
            return;
        }
        this.handler.determineLayerCount(this.structurePattern);
        this.handler.determineOrderedFluidOutputs();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.handler != null) {
            this.handler.invalidate();
        }
    }

    public int getFluidOutputLimit() {
        if (this.handler != null) {
            return this.handler.getLayerCount();
        }
        return super.getFluidOutputLimit();
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.ordered_dt.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.ordered_dt.tooltip.2", (Object[])new Object[0]));
    }
}

