/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import supersymmetry.api.capability.impl.PseudoMultiSteamRecipeLogic;
import supersymmetry.api.metatileentity.steam.SuSySteamProgressIndicator;
import supersymmetry.common.metatileentities.single.steam.SuSySimpleSteamMetaTileEntity;

public class PseudoMultiSteamMachineMetaTileEntity
extends SuSySimpleSteamMetaTileEntity {
    private IBlockState targetBlockState;

    public IBlockState getTargetBlockState() {
        return this.targetBlockState;
    }

    public PseudoMultiSteamMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, SuSySteamProgressIndicator progressIndicator, ICubeRenderer renderer, boolean isBrickedCasing, boolean isHighPressure) {
        super(metaTileEntityId, recipeMap, progressIndicator, renderer, isBrickedCasing, isHighPressure);
        this.workableHandler = new PseudoMultiSteamRecipeLogic(this, recipeMap, isHighPressure, (IFluidTank)this.steamFluidTank, 1.0);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new PseudoMultiSteamMachineMetaTileEntity(this.metaTileEntityId, this.workableHandler.getRecipeMap(), this.progressIndicator, this.renderer, this.isBrickedCasing, this.isHighPressure);
    }

    public void checkAdjacentBlocks() {
        if (this.getWorld() == null || this.getWorld().field_72995_K) {
            this.targetBlockState = null;
            return;
        }
        this.targetBlockState = this.getWorld().func_180495_p(this.getPos().func_177972_a(this.getFrontFacing().func_176734_d()));
    }

    public void onLoad() {
        super.onLoad();
        this.checkAdjacentBlocks();
    }

    public void onPlacement() {
        super.onPlacement();
        this.checkAdjacentBlocks();
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.checkAdjacentBlocks();
    }

    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        boolean wrenchClickSucceeded = super.onWrenchClick(playerIn, hand, facing, hitResult);
        if (wrenchClickSucceeded) {
            this.checkAdjacentBlocks();
        }
        return wrenchClickSucceeded;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }
}

