/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.event;

import gregtech.api.util.GTTeleporter;
import gregtech.api.util.TeleportHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import supersymmetry.common.entities.EntityDropPod;
import supersymmetry.common.event.MobHordePlayerData;
import supersymmetry.common.event.MobHordeWorldData;

public class MobHordeEvent {
    private Function<EntityPlayer, EntityLiving> entitySupplier;
    private int quantityMin;
    private int quantityMax;
    private boolean nightOnly;
    private ResourceLocation advancementUnlock;
    private int timerMin;
    private int timerMax;
    public int timeoutPeriod;
    private int dimension = 0;
    private int maximumDistanceUnderground = -1;
    private boolean canUsePods = true;
    public String KEY;
    public static final Map<String, MobHordeEvent> EVENTS = new HashMap<String, MobHordeEvent>();

    public MobHordeEvent(Function<EntityPlayer, EntityLiving> entitySupplier, int quantityMin, int quantityMax, String name) {
        this(entitySupplier, quantityMin, quantityMax, name, 18000);
    }

    public MobHordeEvent(Function<EntityPlayer, EntityLiving> entitySupplier, int quantityMin, int quantityMax, String name, int timeoutPeriod) {
        this.entitySupplier = entitySupplier;
        this.quantityMin = quantityMin;
        this.quantityMax = quantityMax;
        this.KEY = name;
        this.timeoutPeriod = timeoutPeriod;
        EVENTS.put(name, this);
    }

    public MobHordeEvent setNightOnly(boolean nightOnly) {
        this.nightOnly = nightOnly;
        return this;
    }

    public MobHordeEvent setTimeout(int timeout) {
        this.timeoutPeriod = timeout;
        return this;
    }

    public MobHordeEvent setAdvancementUnlock(ResourceLocation advancementUnlock) {
        this.advancementUnlock = advancementUnlock;
        return this;
    }

    public boolean run(EntityPlayer player) {
        MobHordeWorldData worldData = MobHordeWorldData.get(player.field_70170_p);
        MobHordePlayerData playerData = worldData.getPlayerData(player.getPersistentID());
        return this.run(player, playerData::addEntity);
    }

    public boolean run(EntityPlayer player, Consumer<UUID> uuidConsumer) {
        int quantity = (int)(Math.random() * (double)(this.quantityMax - this.quantityMin) + (double)this.quantityMin);
        boolean didSpawn = false;
        if (this.hasToBeUnderground(player) || !this.canUsePods) {
            for (int i = 0; i < quantity; ++i) {
                didSpawn |= this.spawnMobWithoutPod(player, uuidConsumer);
            }
        } else {
            for (int i = 0; i < quantity; ++i) {
                didSpawn |= this.spawnMobWithPod(player, uuidConsumer);
            }
        }
        return didSpawn;
    }

    public boolean canRun(EntityPlayerMP player) {
        if (this.advancementUnlock != null) {
            Advancement advancement = MobHordeEvent.resourceLocationToAdvancement(this.advancementUnlock, player.field_70170_p);
            if (!player.func_192039_O().func_192747_a(advancement).func_192105_a()) {
                return false;
            }
        }
        if (player.field_71093_bK != this.dimension) {
            return false;
        }
        return !player.field_70170_p.func_72935_r() || !this.nightOnly || this.hasToBeUnderground((EntityPlayer)player);
    }

    private static Advancement resourceLocationToAdvancement(ResourceLocation location, World world) {
        AdvancementManager advManager = (AdvancementManager)ObfuscationReflectionHelper.getPrivateValue(World.class, (Object)world, (String)"field_191951_C");
        return advManager.func_192778_a(location);
    }

    public boolean spawnMobWithPod(EntityPlayer player, Consumer<UUID> uuidConsumer) {
        EntityDropPod pod = new EntityDropPod(player.field_70170_p);
        pod.field_70177_z = (float)Math.random() * 360.0f;
        EntityLiving mob = this.entitySupplier.apply(player);
        double x = player.field_70165_t + Math.random() * 60.0;
        double y = 350.0 + Math.random() * 200.0;
        double z = player.field_70161_v + Math.random() * 60.0;
        GTTeleporter teleporter = new GTTeleporter((WorldServer)player.field_70170_p, x, y, z);
        TeleportHandler.teleport((Entity)mob, (int)player.field_71093_bK, (ITeleporter)teleporter, (double)x, (double)y, (double)z);
        pod.func_70107_b(x, y, z);
        player.field_70170_p.func_72838_d((Entity)pod);
        player.field_70170_p.func_72838_d((Entity)mob);
        mob.func_184205_a((Entity)pod, true);
        mob.func_180482_a(player.field_70170_p.func_175649_E(new BlockPos((Entity)mob)), (IEntityLivingData)null);
        mob.func_110163_bv();
        uuidConsumer.accept(mob.getPersistentID());
        return true;
    }

    public boolean spawnMobWithoutPod(EntityPlayer player, Consumer<UUID> uuidConsumer) {
        EntityLiving mob = this.entitySupplier.apply(player);
        for (int i = 0; i < 4; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            int radius = 16 + (int)(20.0 * Math.random());
            double x = (double)((int)(player.field_70165_t + (double)radius * Math.cos(angle))) + 0.5;
            double z = (double)((int)(player.field_70161_v + (double)radius * Math.sin(angle))) + 0.5;
            double y = Math.floor(player.field_70163_u) + 7.0;
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState blockstate = player.field_70170_p.func_180495_p(pos);
            Block block = blockstate.func_177230_c();
            mob.func_70107_b(x, y, z);
            while ((!mob.func_70601_bi() || !mob.func_70058_J() || block.isAir(blockstate, (IBlockAccess)player.field_70170_p, pos)) && Math.abs(mob.field_70163_u - player.field_70163_u) < 8.0) {
                mob.func_70107_b(x, mob.field_70163_u - 1.0, z);
                pos = new BlockPos(x, mob.field_70163_u - 1.0, z);
                blockstate = player.field_70170_p.func_180495_p(pos);
                block = blockstate.func_177230_c();
            }
            if (!(Math.abs(mob.field_70163_u - player.field_70163_u) < 8.0) || block.isAir(blockstate, (IBlockAccess)player.field_70170_p, pos)) continue;
            player.field_70170_p.func_72838_d((Entity)mob);
            mob.func_110163_bv();
            uuidConsumer.accept(mob.getPersistentID());
            return true;
        }
        return false;
    }

    public int getNextDelay() {
        return this.timerMin + (int)(Math.random() * (double)(this.timerMax - this.timerMin));
    }

    public MobHordeEvent setTimer(int min, int max) {
        this.timerMin = min;
        this.timerMax = max;
        return this;
    }

    public MobHordeEvent setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public MobHordeEvent setMaximumDistanceUnderground(int maximumDistanceUnderground) {
        this.maximumDistanceUnderground = maximumDistanceUnderground;
        return this;
    }

    public MobHordeEvent setCanUsePods(boolean canUsePods) {
        this.canUsePods = canUsePods;
        return this;
    }

    protected boolean hasToBeUnderground(EntityPlayer player) {
        return this.maximumDistanceUnderground != -1 && !player.field_70170_p.func_175710_j(new BlockPos((Entity)player).func_177981_b(this.maximumDistanceUnderground));
    }
}

