/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import javax.annotation.Nonnull;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.properties.EvaporationEnergyProperty;
import supersymmetry.common.metatileentities.multi.electric.MetaTileEntityEvaporationPool;

public class EvapRecipeLogic
extends MultiblockRecipeLogic {
    private final MetaTileEntityEvaporationPool pool;

    public EvapRecipeLogic(MetaTileEntityEvaporationPool tileEntity) {
        super((RecipeMapMultiblockController)tileEntity);
        this.pool = tileEntity;
    }

    public int getJt() {
        if (this.previousRecipe == null || !this.previousRecipe.hasProperty((RecipeProperty)EvaporationEnergyProperty.getInstance())) {
            this.trySearchNewRecipe();
            if (this.previousRecipe == null || !this.previousRecipe.hasProperty((RecipeProperty)EvaporationEnergyProperty.getInstance())) {
                SusyLog.logger.atError().log("Recipe could not be located");
                return 0;
            }
        }
        return (Integer)this.previousRecipe.getProperty((RecipeProperty)EvaporationEnergyProperty.getInstance(), (Object)-1);
    }

    public boolean checkRecipe(Recipe recipe) {
        return recipe.hasProperty((RecipeProperty)EvaporationEnergyProperty.getInstance()) && (Integer)recipe.getProperty((RecipeProperty)EvaporationEnergyProperty.getInstance(), (Object)-1) != -1;
    }

    protected void updateRecipeProgress() {
        boolean coilHeated = false;
        if (this.pool.coilStats != null && this.pool.isHeated()) {
            boolean couldInput;
            int coilHeat = this.pool.coilStats.getCoilTemperature();
            int electricEnergy = coilHeat * ((this.pool.getColumnCount() / 2 + 1) * this.pool.getRowCount() + this.pool.getColumnCount() / 2) / 10;
            if ((long)electricEnergy > this.pool.getEnergyContainer().getEnergyStored()) {
                electricEnergy = (int)this.pool.getEnergyContainer().getEnergyStored();
            }
            if (couldInput = this.pool.inputEnergy(electricEnergy * 10)) {
                this.pool.getEnergyContainer().removeEnergy((long)(electricEnergy / this.pool.coilStats.getEnergyDiscount()));
                coilHeated = electricEnergy > 0;
            }
        }
        this.pool.areCoilsHeating = coilHeated;
        int Jt = this.getJt();
        if (Jt <= 0) {
            this.invalidate();
            this.setActive(false);
            this.pool.areCoilsHeating = false;
            return;
        }
        int maxSteps = this.pool.calcMaxSteps(Jt);
        if (maxSteps > 0) {
            this.hasNotEnoughEnergy = false;
            this.pool.isRecipeStalled = false;
            int actualSteps = Math.min(Math.max(this.maxProgressTime >>> 2, 1), maxSteps);
            int kJFloor = this.getJt() * actualSteps / 1000;
            int joulesNeeded = this.pool.getKiloJoules() <= kJFloor ? this.getJt() * actualSteps - this.pool.getKiloJoules() * 1000 : this.getJt() * actualSteps - kJFloor * 1000;
            if (this.pool.getJoulesBuffer() < joulesNeeded) {
                ++kJFloor;
                joulesNeeded = 0;
            }
            this.pool.setKiloJoules(this.pool.getKiloJoules() - kJFloor);
            this.pool.setJoulesBuffer(this.pool.getJoulesBuffer() - joulesNeeded);
            this.progressTime += actualSteps;
            if (this.progressTime >= this.maxProgressTime) {
                this.completeRecipe();
            }
        } else {
            this.hasNotEnoughEnergy = true;
            this.pool.isRecipeStalled = true;
        }
    }

    protected long getEnergyInputPerSecond() {
        return super.getEnergyInputPerSecond() == 0L ? Integer.MAX_VALUE : super.getEnergyInputPerSecond();
    }

    protected long getEnergyStored() {
        return Math.max(0L, super.getEnergyStored());
    }

    protected long getEnergyCapacity() {
        return super.getEnergyCapacity() == 0L ? Integer.MAX_VALUE : super.getEnergyCapacity();
    }

    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        return true;
    }

    protected boolean hasEnoughPower(@Nonnull int[] resultOverclock) {
        int totalEUt = resultOverclock[0] * resultOverclock[1];
        if (totalEUt >= 0) {
            int capacity = (long)totalEUt > this.getEnergyCapacity() / 2L ? resultOverclock[0] : totalEUt;
            return this.getEnergyStored() >= (long)capacity;
        }
        return true;
    }

    public long getMaxVoltage() {
        return Math.max(1L, super.getMaxVoltage());
    }

    protected int[] runOverclockingLogic(@Nonnull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int recipeDuration, int amountOC) {
        return new int[]{recipeEUt, recipeDuration};
    }

    public long getMaximumOverclockVoltage() {
        return this.getEnergyCapacity() == 0L ? GTValues.V[1] : super.getMaximumOverclockVoltage();
    }
}

