/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.capability.impl;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.util.GTUtility;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.capability.impl.CatalystRecipeLogic;
import supersymmetry.api.recipes.builders.logic.SuSyOverclockingLogic;

public class ContinuousRecipeLogic
extends CatalystRecipeLogic {
    public ContinuousRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
        super(tileEntity, recipeMap, energyContainer);
    }

    public boolean prepareRecipe(Recipe recipe) {
        recipe = Recipe.trimRecipeOutputs((Recipe)recipe, (RecipeMap)this.getRecipeMap(), (int)this.metaTileEntity.getItemOutputLimit(), (int)this.metaTileEntity.getFluidOutputLimit());
        this.calculateOverclockLimit(recipe);
        recipe = this.findParallelRecipe(recipe, this.getInputInventory(), this.getInputTank(), this.getOutputInventory(), this.getOutputTank(), this.getMaxParallelVoltage(), this.getParallelLimit());
        if (recipe != null && this.setupAndConsumeRecipeInputs(recipe, this.getInputInventory())) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    @Override
    protected int[] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int amountOC) {
        double[] overclock = this.runContinuousOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC);
        return new int[]{(int)overclock[0], overclock[1] <= 1.0 ? 1 : (int)overclock[1]};
    }

    protected double[] runContinuousOverclockingLogic(int recipeEUt, long maxVoltage, int duration, int amountOC) {
        if (this.requiredCatalystTier != -1 && this.catalystInfo != null) {
            return SuSyOverclockingLogic.continuousCatalystOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC, this.catalystInfo, this.requiredCatalystTier, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
        }
        return SuSyOverclockingLogic.continuousOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
    }

    protected void calculateOverclockLimit(Recipe recipe) {
        double parallelLimitDouble;
        if (!this.isAllowOverclocking()) {
            return;
        }
        byte recipeTier = GTUtility.getTierByVoltage((long)this.recipeEUt);
        int maximumTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        if (maximumTier <= 1) {
            return;
        }
        int numberOfOCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        this.setParallelLimit((parallelLimitDouble = 1.0 / this.runContinuousOverclockingLogic(recipe.getEUt(), this.getMaximumOverclockVoltage(), recipe.getDuration(), numberOfOCs)[1]) <= 1.0 ? 1 : (int)parallelLimitDouble);
    }
}

