/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.capability.impl;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.builders.logic.SuSyOverclockingLogic;
import supersymmetry.api.recipes.catalysts.CatalystInfo;
import supersymmetry.api.recipes.properties.CatalystProperty;
import supersymmetry.api.recipes.properties.CatalystPropertyValue;

public class ContinuousMultiblockRecipeLogic
extends MultiblockRecipeLogic {
    private CatalystInfo catalystInfo;
    private int requiredCatalystTier;

    public ContinuousMultiblockRecipeLogic(RecipeMapMultiblockController tileEntity) {
        super(tileEntity);
    }

    public ContinuousMultiblockRecipeLogic(RecipeMapMultiblockController tileEntity, boolean hasPerfectOC) {
        super(tileEntity, hasPerfectOC);
    }

    protected void tryFindCatalystInfo(@NotNull Recipe recipe) {
        this.catalystInfo = null;
        this.requiredCatalystTier = -1;
        if (recipe.hasProperty((RecipeProperty)CatalystProperty.getInstance())) {
            CatalystPropertyValue property = (CatalystPropertyValue)recipe.getProperty((RecipeProperty)CatalystProperty.getInstance(), null);
            if (property == null) {
                return;
            }
            if (property.getTier() == -1) {
                return;
            }
            for (int i = 0; i < this.getInputInventory().getSlots(); ++i) {
                CatalystInfo info;
                ItemStack is = this.getInputInventory().getStackInSlot(i);
                if (is.func_190926_b() || (info = property.getCatalystGroup().getCatalystInfos().get(is)) == null || this.catalystInfo != null && this.catalystInfo.compareTo(info) <= 0) continue;
                this.catalystInfo = info;
            }
            if (this.catalystInfo != null) {
                SusyLog.logger.info("3r390r9");
                this.requiredCatalystTier = property.getTier();
            }
        }
    }

    public boolean prepareRecipe(Recipe recipe) {
        recipe = Recipe.trimRecipeOutputs((Recipe)recipe, (RecipeMap)this.getRecipeMap(), (int)this.metaTileEntity.getItemOutputLimit(), (int)this.metaTileEntity.getFluidOutputLimit());
        this.calculateOverclockLimit(recipe);
        recipe = this.findParallelRecipe(recipe, this.getInputInventory(), this.getInputTank(), this.getOutputInventory(), this.getOutputTank(), this.getMaxParallelVoltage(), this.getParallelLimit());
        if (recipe != null && this.setupAndConsumeRecipeInputs(recipe, this.getInputInventory())) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    protected void trySearchNewRecipeCombined() {
        long maxVoltage = this.getMaxVoltage();
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        Recipe currentRecipe = this.checkPreviousRecipe() ? this.previousRecipe : this.findRecipe(maxVoltage, importInventory, importFluids);
        if (currentRecipe != null) {
            this.previousRecipe = currentRecipe;
            this.tryFindCatalystInfo(currentRecipe);
        }
        boolean bl = this.invalidInputsForRecipes = currentRecipe == null;
        if (currentRecipe != null && this.checkRecipe(currentRecipe)) {
            this.prepareRecipe(currentRecipe);
        }
    }

    protected void modifyOverclockPre(int @NotNull [] values, @NotNull IRecipePropertyStorage storage) {
        super.modifyOverclockPre(values, storage);
        Tuple maintenanceValues = this.getMaintenanceValues();
        if ((Double)maintenanceValues.func_76340_b() != 1.0) {
            values[1] = (int)Math.round((double)values[1] * (Double)maintenanceValues.func_76340_b());
        }
        if (this.catalystInfo != null) {
            values[0] = Math.min(1, (int)((double)values[0] * this.catalystInfo.getEnergyEfficiency()));
            values[1] = Math.min(1, (int)((double)values[1] * this.catalystInfo.getSpeedEfficiency()));
        }
    }

    public boolean checkRecipe(@NotNull Recipe recipe) {
        CatalystPropertyValue property = (CatalystPropertyValue)recipe.getProperty((RecipeProperty)CatalystProperty.getInstance(), null);
        if (property == null || property.getTier() == -1) {
            return super.checkRecipe(recipe);
        }
        if (this.catalystInfo == null) {
            return false;
        }
        return this.catalystInfo.getTier() >= property.getTier() && super.checkRecipe(recipe);
    }

    protected int[] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int amountOC) {
        double[] overclock = this.runContinuousOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC);
        return new int[]{(int)overclock[0], overclock[1] <= 1.0 ? 1 : (int)overclock[1]};
    }

    protected double[] runContinuousOverclockingLogic(int recipeEUt, long maxVoltage, int duration, int amountOC) {
        if (this.requiredCatalystTier != -1 && this.catalystInfo != null) {
            return SuSyOverclockingLogic.continuousCatalystOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC, this.catalystInfo, this.requiredCatalystTier, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
        }
        return SuSyOverclockingLogic.continuousOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
    }

    protected void calculateOverclockLimit(Recipe recipe) {
        double parallelLimitDouble;
        if (!this.isAllowOverclocking()) {
            return;
        }
        byte recipeTier = GTUtility.getTierByVoltage((long)this.recipeEUt);
        int maximumTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        if (maximumTier <= 1) {
            return;
        }
        int numberOfOCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        this.setParallelLimit((parallelLimitDouble = 1.0 / this.runContinuousOverclockingLogic(recipe.getEUt(), this.getMaximumOverclockVoltage(), recipe.getDuration(), numberOfOCs)[1]) <= 1.0 ? 1 : (int)parallelLimitDouble);
    }
}

