/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.capability.impl;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.builders.logic.SuSyOverclockingLogic;
import supersymmetry.api.recipes.catalysts.CatalystInfo;
import supersymmetry.api.recipes.properties.CatalystProperty;
import supersymmetry.api.recipes.properties.CatalystPropertyValue;

public class CatalystRecipeLogic
extends RecipeLogicEnergy {
    @Nullable
    protected CatalystInfo catalystInfo;
    protected int requiredCatalystTier;

    public CatalystRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
        super(tileEntity, recipeMap, energyContainer);
    }

    protected void tryFindCatalystInfo(@NotNull Recipe recipe) {
        this.catalystInfo = null;
        this.requiredCatalystTier = -1;
        if (recipe.hasProperty((RecipeProperty)CatalystProperty.getInstance())) {
            CatalystPropertyValue property = (CatalystPropertyValue)recipe.getProperty((RecipeProperty)CatalystProperty.getInstance(), null);
            if (property == null) {
                return;
            }
            if (property.getTier() == -1) {
                return;
            }
            for (int i = 0; i < this.getInputInventory().getSlots(); ++i) {
                CatalystInfo info;
                ItemStack is = this.getInputInventory().getStackInSlot(i);
                if (is.func_190926_b() || (info = property.getCatalystGroup().getCatalystInfos().get(is)) == null || this.catalystInfo != null && this.catalystInfo.compareTo(info) <= 0) continue;
                this.catalystInfo = info;
            }
            if (this.catalystInfo != null) {
                SusyLog.logger.info("3r390r9");
                this.requiredCatalystTier = property.getTier();
            }
        }
    }

    protected void trySearchNewRecipe() {
        long maxVoltage = this.getMaxVoltage();
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        Recipe currentRecipe = this.checkPreviousRecipe() ? this.previousRecipe : this.findRecipe(maxVoltage, importInventory, importFluids);
        if (currentRecipe != null) {
            this.previousRecipe = currentRecipe;
            this.tryFindCatalystInfo(currentRecipe);
        }
        boolean bl = this.invalidInputsForRecipes = currentRecipe == null;
        if (currentRecipe != null && this.checkRecipe(currentRecipe)) {
            this.prepareRecipe(currentRecipe);
        }
    }

    public boolean checkRecipe(@NotNull Recipe recipe) {
        CatalystPropertyValue property = (CatalystPropertyValue)recipe.getProperty((RecipeProperty)CatalystProperty.getInstance(), null);
        if (property == null || property.getTier() == -1) {
            return super.checkRecipe(recipe);
        }
        if (this.catalystInfo == null) {
            return false;
        }
        return this.catalystInfo.getTier() >= property.getTier() && super.checkRecipe(recipe);
    }

    protected int[] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int amountOC) {
        if (this.requiredCatalystTier != -1 && this.catalystInfo != null) {
            return SuSyOverclockingLogic.catalystOverclockingLogic(recipeEUt, maxVoltage, duration, amountOC, this.catalystInfo, this.requiredCatalystTier, this.getOverclockingDurationDivisor(), this.getOverclockingVoltageMultiplier());
        }
        return OverclockingLogic.standardOverclockingLogic((int)recipeEUt, (long)maxVoltage, (int)duration, (int)amountOC, (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
    }

    protected void modifyOverclockPre(int @NotNull [] values, @NotNull IRecipePropertyStorage storage) {
        super.modifyOverclockPre(values, storage);
        if (this.catalystInfo != null) {
            values[0] = Math.min(1, (int)((double)values[0] * this.catalystInfo.getEnergyEfficiency()));
            values[1] = Math.min(1, (int)((double)values[1] * this.catalystInfo.getSpeedEfficiency()));
        }
    }
}

