/*
 * Decompiled with CFR 0.152.
 */
package serenetweaks.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class TimeStampsWorldSavedData
extends WorldSavedData {
    private static Map<String, Integer> timeStampMap = new HashMap<String, Integer>();
    private static final String DATA_NAME = "serenetweaks_TimeStampData";

    public static void setChunkTimeStamp(Chunk chunk, int timeStamp) {
        if (timeStampMap.isEmpty()) {
            TimeStampsWorldSavedData.get(chunk.func_177412_p());
        }
        ChunkPos chunkPos = chunk.func_76632_l();
        String key = chunkPos.toString();
        timeStampMap.put(key, timeStamp);
    }

    public static int getChunkTimeStamp(Chunk chunk) {
        ChunkPos chunkPos;
        String key;
        if (timeStampMap.isEmpty()) {
            TimeStampsWorldSavedData.get(chunk.func_177412_p());
        }
        if (!timeStampMap.containsKey(key = (chunkPos = chunk.func_76632_l()).toString())) {
            return 0;
        }
        return timeStampMap.get(key);
    }

    public TimeStampsWorldSavedData() {
        super(DATA_NAME);
    }

    public TimeStampsWorldSavedData(String dataName) {
        super(dataName);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Set keys = nbt.func_150296_c();
        for (String key : keys) {
            int value = nbt.func_74762_e(key);
            timeStampMap.put(key, value);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        Set<String> keys = timeStampMap.keySet();
        for (String key : keys) {
            int value = timeStampMap.get(key);
            nbt.func_74768_a(key, value);
        }
        return nbt;
    }

    public static TimeStampsWorldSavedData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        TimeStampsWorldSavedData instance = (TimeStampsWorldSavedData)storage.func_75742_a(TimeStampsWorldSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new TimeStampsWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

