/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration.internal;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ladylib.LadyLib;
import ladylib.registration.internal.AutoRegistryRef;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

class FieldRef
extends AutoRegistryRef<Field> {
    FieldRef(String modId, Field field) {
        super(modId, field);
    }

    @Override
    boolean isValidForRegistry(IForgeRegistry<?> registry) {
        return registry.getRegistrySuperType().isAssignableFrom(((Field)this.referenced).getType());
    }

    @Override
    IForgeRegistryEntry nameAndGet() {
        try {
            String name = ((Field)this.referenced).getName().toLowerCase(Locale.ENGLISH);
            IForgeRegistryEntry value = (IForgeRegistryEntry)((Field)this.referenced).get(null);
            if (value == null) {
                LadyLib.LOGGER.error("A referenced marked to be automatically registered has a null value {}", (Object)this.referenced);
                return null;
            }
            value.setRegistryName(new ResourceLocation(this.modId, name));
            ((Optional)UNLOCALIZED_NAMES_CACHE.get(((Field)this.referenced).getType())).ifPresent(handle -> {
                try {
                    handle.invoke(value, this.modId + "." + name);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            });
            return value;
        }
        catch (IllegalAccessException | ExecutionException e) {
            LadyLib.LOGGER.error("Could not access an auto registered reference", (Throwable)e);
            return null;
        }
    }
}

