/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration.internal;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ladylib.capability.internal.CapabilityRegistrar;
import ladylib.registration.AutoRegister;
import ladylib.registration.AutoRegisterTile;
import ladylib.registration.BlockRegistrar;
import ladylib.registration.ItemRegistrar;
import ladylib.registration.internal.AutoRegistryRef;
import ladylib.registration.internal.ClientRegistrar;
import ladylib.registration.internal.FieldRef;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutoRegistrar {
    private ItemRegistrar itemRegistrar;
    private BlockRegistrar blockRegistrar;
    private CapabilityRegistrar capRegistrar;
    private List<AutoRegistryRef> references = new ArrayList<AutoRegistryRef>();
    private Map<Class<? extends IForgeRegistryEntry>, Map<ResourceLocation, IForgeRegistryEntry>> remappings = new HashMap<Class<? extends IForgeRegistryEntry>, Map<ResourceLocation, IForgeRegistryEntry>>();

    public AutoRegistrar(ASMDataTable asmData) {
        this.itemRegistrar = new ItemRegistrar();
        this.blockRegistrar = new BlockRegistrar(this.itemRegistrar);
        this.capRegistrar = new CapabilityRegistrar();
        this.findRegistryHandlers(asmData);
        this.capRegistrar.findCapabilityImplementations(asmData);
    }

    private void findRegistryHandlers(ASMDataTable asmData) {
        Set allRegistryHandlers = asmData.getAll(AutoRegister.class.getName());
        for (ASMDataTable.ASMData data : allRegistryHandlers) {
            String modId = (String)data.getAnnotationInfo().get("value");
            String className = data.getClassName();
            String annotationTarget = data.getObjectName();
            boolean isClass = className.equals(annotationTarget);
            try {
                Class<?> clazz = Class.forName(data.getClassName(), false, this.getClass().getClassLoader());
                if (isClass) {
                    this.scanClassForFields(modId, clazz);
                    continue;
                }
                this.references.add(new FieldRef(modId, clazz.getDeclaredField(annotationTarget)));
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public void autoRegisterTileEntities(ASMDataTable asmData) {
        Set autoRegisterTypes = asmData.getAll(AutoRegisterTile.class.getName());
        for (ASMDataTable.ASMData data : autoRegisterTypes) {
            String modId = (String)data.getAnnotationInfo().get("value");
            String className = data.getClassName();
            try {
                Class<?> teClass = Class.forName(className, true, this.getClass().getClassLoader());
                String name = (String)data.getAnnotationInfo().get("name");
                if (name == null || name.isEmpty()) {
                    name = teClass.getSimpleName().toLowerCase(Locale.ENGLISH);
                }
                GameRegistry.registerTileEntity(teClass, (String)(modId + ":" + name));
                if (FMLCommonHandler.instance().getSide() != Side.CLIENT) continue;
                ClientRegistrar.registerTESR(teClass, (Type)data.getAnnotationInfo().get("renderer"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void scanClassForFields(String modId, Class<?> autoRegisterClass) {
        for (Field f : autoRegisterClass.getFields()) {
            boolean isMatch;
            int mods = f.getModifiers();
            boolean bl = isMatch = Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
            if (!isMatch || !IForgeRegistryEntry.class.isAssignableFrom(f.getType()) || f.isAnnotationPresent(AutoRegister.Ignore.class) || f.isAnnotationPresent(AutoRegister.class)) continue;
            this.references.add(new FieldRef(modId, f));
        }
    }

    @SubscribeEvent
    void onRegistryRegister(RegistryEvent.Register event) {
        this.shutupForge(() -> this.references.stream().filter(ref -> ref.isValidForRegistry(event.getRegistry())).forEach(ref -> {
            IForgeRegistryEntry value = ref.nameAndGet();
            for (String oldName : ref.getOldNames()) {
                this.remappings.computeIfAbsent(event.getRegistry().getRegistrySuperType(), a -> new HashMap()).put(new ResourceLocation(ref.getModId(), oldName), value);
            }
            if (value instanceof Item) {
                this.itemRegistrar.addItem((Item)value, ref.isListed(), ref.getOreNames());
            } else if (value instanceof Block) {
                this.blockRegistrar.addBlock((Block)value, ref.isListed(), ref.isMakeItemBlock(), ref.getOreNames());
            } else {
                event.getRegistry().register(value);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutupForge(Runnable op) {
        try {
            Logger log = FMLLog.log;
            Field privateConfigF = org.apache.logging.log4j.core.Logger.class.getDeclaredField("privateConfig");
            privateConfigF.setAccessible(true);
            Object privateConfig = privateConfigF.get(log);
            Field intLevelF = privateConfig.getClass().getDeclaredField("intLevel");
            intLevelF.setAccessible(true);
            int intLevel = intLevelF.getInt(privateConfig);
            intLevelF.set(privateConfig, 299);
            try {
                op.run();
            }
            finally {
                intLevelF.set(privateConfig, intLevel);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    void onRegistryMissingMappings(RegistryEvent.MissingMappings event) {
        ImmutableList mappings = event.getMappings();
        Map<ResourceLocation, IForgeRegistryEntry> remaps = this.remappings.get(event.getRegistry().getRegistrySuperType());
        if (remaps == null) {
            return;
        }
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            if (!remaps.containsKey(mapping.key)) continue;
            mapping.remap(remaps.get(mapping.key));
        }
    }

    public BlockRegistrar getBlockRegistrar() {
        return this.blockRegistrar;
    }

    public ItemRegistrar getItemRegistrar() {
        return this.itemRegistrar;
    }
}

