/*
 * Decompiled with CFR 0.152.
 */
package ladylib.networking.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class HTTPRequestHelper {
    private static final Gson GSON = new Gson();
    private static final Executor THREAD_POOL = new ThreadPoolExecutor(0, 3, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), runnable -> new Thread(runnable, "LadyLib HTTP Helper"));
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);

    public static void getJSON(String url, JsonCallback success) {
        try {
            HTTPRequestHelper.getJSON(new URL(url)).thenAccept((Consumer)success);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CompletableFuture<JsonElement> getJSON(URL url) {
        return CompletableFuture.supplyAsync(() -> HTTPRequestHelper.requestJSON(url), THREAD_POOL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonElement requestJSON(URL url) {
        try {
            URLConnection page = HTTPRequestHelper.openUrlConnection(url);
            if (page instanceof HttpURLConnection) {
                int code = ((HttpURLConnection)page).getResponseCode();
                if (code <= 200) throw new RuntimeException("Got a bad response code from the server (code " + code + ")");
                if (code > 299) {
                    throw new RuntimeException("Got a bad response code from the server (code " + code + ")");
                }
            }
            page.connect();
            try (InputStreamReader in = new InputStreamReader(page.getInputStream());){
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)in, JsonElement.class);
                return jsonElement;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not connect to " + url + ". Maybe you're offline ?", e);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Bad json coming from " + url + ". This should be reported.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLConnection openUrlConnection(URL url) throws IOException {
        URL currentUrl = url;
        for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
            URLConnection c = currentUrl.openConnection();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)c;
                huc.setInstanceFollowRedirects(false);
                int responseCode = huc.getResponseCode();
                if (responseCode >= 300 && responseCode <= 399) {
                    try {
                        String loc = huc.getHeaderField("Location");
                        currentUrl = new URL(currentUrl, loc);
                        continue;
                    }
                    finally {
                        huc.disconnect();
                    }
                }
            }
            return c;
        }
        throw new IOException("Too many redirects while trying to fetch " + url);
    }

    @FunctionalInterface
    public static interface JsonCallback
    extends Consumer<JsonElement> {
    }
}

