/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ladylib.LadyLib;
import ladylib.nbt.BaseNBTAdapters;
import ladylib.nbt.CapabilityNBTTypeAdapterFactory;
import ladylib.nbt.CollectionNBTTypeAdapterFactory;
import ladylib.nbt.EnumNBTTypeAdapterFactory;
import ladylib.nbt.ImmutableCollectionNBTAdapterFactory;
import ladylib.nbt.MapNBTTypeAdapterFactory;
import ladylib.nbt.NBTMutatingTypeAdapter;
import ladylib.nbt.NBTSelfTypeAdapterFactory;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.NBTTypeAdapterFactory;
import ladylib.nbt.ReflectiveNBTAdapterFactory;
import ladylib.nbt.RegistryEntryNBTAdapterFactory;
import ladylib.nbt.SerializableNBTTypeAdapterFactory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class TagAdapters {
    private static final List<NBTTypeAdapterFactory> factories = new ArrayList<NBTTypeAdapterFactory>();
    private static final Map<TypeToken<?>, NBTAdapterEntry> cache = new HashMap();
    private static final Map<TypeToken<?>, Supplier<?>> defaultValues = new HashMap();

    private static <T> void addPrimitiveFactory(Class<T> primitive, Class<T> wrapper, Supplier<NBTTypeAdapter<T, ?>> factory) {
        NBTTypeAdapter instance = factory.get();
        factories.add((type, allowMutating) -> type.getRawType() == primitive || type.getRawType() == wrapper ? instance : null);
    }

    private static <T> void addFactory(Class<T> clazz, Supplier<NBTTypeAdapter<T, ?>> factory) {
        NBTTypeAdapter instance = factory.get();
        factories.add((type, allowMutating) -> clazz == type.getRawType() ? instance : null);
    }

    public static void addAdapterFactory(NBTTypeAdapterFactory factory) {
        factories.add(0, factory);
    }

    public static NBTTypeAdapter getNBTAdapter(Field field) {
        return TagAdapters.getNBTAdapter(TypeToken.get((Type)field.getGenericType()), true);
    }

    public static <T, NBT extends NBTBase> NBTTypeAdapter<T, NBT> getNBTAdapter(TypeToken<T> type, boolean allowMutating) {
        return cache.computeIfAbsent(type, NBTAdapterEntry::new).computeTypeAdapter(allowMutating);
    }

    public static <T> void setDefaultValue(TypeToken<T> type, Supplier<T> defaultProvider) {
        defaultValues.put(type, defaultProvider);
    }

    public static <T> Optional<T> getDefaultValue(TypeToken<T> type) {
        return Optional.ofNullable(defaultValues.get(type)).map(s -> s.get());
    }

    static {
        TagAdapters.addPrimitiveFactory(Boolean.TYPE, Boolean.class, BaseNBTAdapters.BooleanAdapter::new);
        TagAdapters.addPrimitiveFactory(Byte.TYPE, Byte.class, BaseNBTAdapters.ByteAdapter::new);
        TagAdapters.addPrimitiveFactory(Short.TYPE, Short.class, BaseNBTAdapters.ShortAdapter::new);
        TagAdapters.addPrimitiveFactory(Integer.TYPE, Integer.class, BaseNBTAdapters.IntAdapter::new);
        TagAdapters.addPrimitiveFactory(Float.TYPE, Float.class, BaseNBTAdapters.FloatAdapter::new);
        TagAdapters.addPrimitiveFactory(Long.TYPE, Long.class, BaseNBTAdapters.LongAdapter::new);
        TagAdapters.addPrimitiveFactory(Double.TYPE, Double.class, BaseNBTAdapters.DoubleAdapter::new);
        TagAdapters.addFactory(String.class, BaseNBTAdapters.StringAdapter::new);
        TagAdapters.addFactory(ItemStack.class, BaseNBTAdapters.ItemStackAdapter::new);
        TagAdapters.addFactory(BlockPos.class, BaseNBTAdapters.BlockPosAdapter::new);
        TagAdapters.addFactory(UUID.class, BaseNBTAdapters.UUIDAdapter::new);
        factories.add(new NBTSelfTypeAdapterFactory());
        factories.add(new EnumNBTTypeAdapterFactory());
        factories.add(new SerializableNBTTypeAdapterFactory());
        factories.add(new RegistryEntryNBTAdapterFactory());
        factories.add(new ImmutableCollectionNBTAdapterFactory());
        factories.add(new CollectionNBTTypeAdapterFactory());
        factories.add(new MapNBTTypeAdapterFactory());
        factories.add(new CapabilityNBTTypeAdapterFactory());
        factories.add(ReflectiveNBTAdapterFactory.INSTANCE);
    }

    public static class NBTAdapterEntry {
        private TypeToken type;
        private NBTTypeAdapter typeAdapter;
        private NBTMutatingTypeAdapter mutatingTypeAdapter;

        public NBTAdapterEntry(TypeToken type) {
            this.type = type;
        }

        @Nonnull
        public NBTTypeAdapter computeTypeAdapter(boolean allowMutating) {
            if (allowMutating && this.mutatingTypeAdapter != null) {
                return this.mutatingTypeAdapter;
            }
            if (this.typeAdapter != null) {
                return this.typeAdapter;
            }
            for (NBTTypeAdapterFactory factory : factories) {
                NBTTypeAdapter candidate;
                try {
                    candidate = factory.create(this.type, allowMutating);
                }
                catch (Exception e) {
                    LadyLib.LOGGER.error((Message)new FormattedMessage("Factory {} threw an exception", (Object)factory), (Throwable)e);
                    continue;
                }
                if (candidate == null) continue;
                if (candidate instanceof NBTMutatingTypeAdapter) {
                    if (!allowMutating) {
                        throw new IllegalStateException("A factory returned a mutating type adapter despite them not being allowed to");
                    }
                    this.mutatingTypeAdapter = (NBTMutatingTypeAdapter)candidate;
                } else {
                    this.typeAdapter = candidate;
                }
                return candidate;
            }
            throw new IllegalArgumentException("LadyLib does not know how to serialize " + this.type + " as NBT");
        }
    }
}

