/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.gson.reflect.TypeToken;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.AbstractNBTTypeAdapter;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.NBTTypeAdapterFactory;
import ladylib.nbt.TagAdapters;
import net.minecraft.nbt.NBTBase;

public class NBTSelfTypeAdapterFactory
implements NBTTypeAdapterFactory<NBTBase, NBTBase> {
    @Override
    @Nullable
    public NBTTypeAdapter<NBTBase, NBTBase> create(TypeToken type, boolean allowMutating) {
        Class rawType = type.getRawType();
        if (NBTBase.class.isAssignableFrom(rawType)) {
            MethodHandles.Lookup lookup = ReflectionUtil.getTrustedLookup(rawType);
            TagAdapters.setDefaultValue(type, (Supplier)ReflectionUtil.createFactory(rawType, "get", Supplier.class, lookup));
            return new NBTSelfAdapter<NBTBase>((TypeToken<NBTBase>)type);
        }
        return null;
    }

    public static class NBTSelfAdapter<NBT extends NBTBase>
    extends AbstractNBTTypeAdapter<NBT, NBT> {
        protected NBTSelfAdapter(TypeToken<NBT> typeToken) {
            super(typeToken);
        }

        @Override
        public NBT toNBT(NBT value) {
            return value;
        }

        @Override
        public NBT fromNBT(NBTBase nbt) {
            return (NBT)((NBTBase)this.castAnd(nbt, this.typeToken.getRawType(), Function.identity()));
        }
    }
}

