/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.common.collect.ImmutableCollection;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.function.Supplier;
import ladylib.LadyLib;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.CollectionNBTTypeAdapterFactory;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.NBTTypeAdapterFactory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;

public class ImmutableCollectionNBTAdapterFactory
implements NBTTypeAdapterFactory<ImmutableCollection, NBTTagList> {
    @Override
    public NBTTypeAdapter<ImmutableCollection, NBTTagList> create(TypeToken type, boolean allowMutating) {
        Class rawType = type.getRawType();
        if (!ImmutableCollection.class.isAssignableFrom(rawType)) {
            return null;
        }
        NBTTypeAdapter elementAdapter = CollectionNBTTypeAdapterFactory.getElementTypeAdapter(type, 0);
        try {
            Class<?> builder = Class.forName(rawType.getName() + "$Builder");
            Supplier builderFactory = (Supplier)ReflectionUtil.createFactory(builder, "get", Supplier.class);
            ImmutableCollectionNBTAdapter ret = new ImmutableCollectionNBTAdapter(elementAdapter, builderFactory);
            return ret;
        }
        catch (ClassNotFoundException | ReflectionUtil.UnableToGetFactoryException e) {
            LadyLib.LOGGER.error("Unable to create builder factory", (Throwable)e);
            return null;
        }
    }

    public static class ImmutableCollectionNBTAdapter<E>
    extends CollectionNBTTypeAdapterFactory.CollectionBaseAdapter<E> {
        protected final Supplier<ImmutableCollection.Builder<E>> builderSupplier;

        public ImmutableCollectionNBTAdapter(NBTTypeAdapter<E, NBTBase> elementAdapter, Supplier<ImmutableCollection.Builder<E>> supplier) {
            super(elementAdapter);
            this.builderSupplier = supplier;
        }

        @Override
        public Collection<E> fromNBT(Collection<E> value, NBTBase nbt) {
            return this.fromNBT(nbt);
        }

        @Override
        public ImmutableCollection<E> fromNBT(NBTBase nbt) {
            ImmutableCollection.Builder<E> ret = this.builderSupplier.get();
            this.cast(nbt, NBTTagList.class).ifPresent(list -> {
                for (NBTBase nbtBase : list) {
                    ret.add(this.elementAdapter.fromNBT(nbtBase));
                }
            });
            return ret.build();
        }
    }
}

