/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.nbt.NBTMutatingTypeAdapter;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.NBTTypeAdapterFactory;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityNBTTypeAdapterFactory<C>
implements NBTTypeAdapterFactory<C, NBTBase> {
    private IdentityHashMap<String, Capability<?>> providers;

    @Override
    @Nullable
    public NBTTypeAdapter<C, NBTBase> create(TypeToken type, boolean allowMutating) {
        Capability<?> capability;
        if (!allowMutating) {
            return null;
        }
        if (this.providers == null) {
            try {
                Field f = CapabilityManager.class.getDeclaredField("providers");
                f.setAccessible(true);
                this.providers = (IdentityHashMap)f.get(CapabilityManager.INSTANCE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LadyLib.LOGGER.error("Could not get capability providers", (Throwable)e);
                return null;
            }
        }
        if ((capability = this.providers.get(type.getRawType().getName().intern())) != null) {
            return new CapabilityNBTTypeAdapter(capability);
        }
        return null;
    }

    public static class CapabilityNBTTypeAdapter<C>
    implements NBTMutatingTypeAdapter<C, NBTBase> {
        private final Capability<C> capability;

        public CapabilityNBTTypeAdapter(Capability<C> capability) {
            this.capability = capability;
        }

        @Override
        public NBTBase toNBT(C value) {
            return this.capability.writeNBT(value, null);
        }

        @Override
        public C fromNBT(C value, NBTBase nbt) {
            this.capability.readNBT(value, null, nbt);
            return value;
        }
    }
}

