/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import java.util.UUID;
import ladylib.nbt.AbstractNBTTypeAdapter;
import ladylib.nbt.DefaultValue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;

public interface BaseNBTAdapters {
    @DefaultValue(value={byte.class, Byte.class})
    public static final byte DEFAULT_BYTE = 0;
    @DefaultValue(value={short.class, Short.class})
    public static final short DEFAULT_SHORT = 0;
    @DefaultValue(value={int.class, Integer.class})
    public static final int DEFAULT_INT = 0;
    @DefaultValue(value={float.class, Float.class})
    public static final float DEFAULT_FLOAT = 0.0f;
    @DefaultValue(value={long.class, Long.class})
    public static final long DEFAULT_LONG = 0L;
    @DefaultValue(value={double.class, Double.class})
    public static final double DEFAULT_DOUBLE = 0.0;
    @DefaultValue(value={boolean.class, Boolean.class})
    public static final boolean DEFAULT_BOOLEAN = false;
    @DefaultValue(value={String.class})
    public static final String DEFAULT = "";

    public static class UUIDAdapter
    extends AbstractNBTTypeAdapter<UUID, NBTTagString> {
        @DefaultValue(value={UUID.class})
        public static final UUID DEFAULT = new UUID(0L, 0L);

        @Override
        public NBTTagString toNBT(UUID value) {
            return new NBTTagString(value.toString());
        }

        @Override
        public UUID fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagString.class, tag -> {
                String serialized = tag.func_150285_a_();
                return serialized.isEmpty() ? new UUID(0L, 0L) : UUID.fromString(serialized);
            });
        }
    }

    public static class BlockPosAdapter
    extends AbstractNBTTypeAdapter<BlockPos, NBTTagLong> {
        @DefaultValue(value={BlockPos.class})
        public static final BlockPos DEFAULT = BlockPos.field_177992_a;

        @Override
        public NBTTagLong toNBT(BlockPos value) {
            return new NBTTagLong(value.func_177986_g());
        }

        @Override
        public BlockPos fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagLong.class, tag -> BlockPos.func_177969_a((long)tag.func_150291_c()));
        }
    }

    public static class ItemStackAdapter
    extends AbstractNBTTypeAdapter<ItemStack, NBTTagCompound> {
        @DefaultValue(value={ItemStack.class})
        public static final ItemStack DEFAULT = ItemStack.field_190927_a;

        @Override
        public NBTTagCompound toNBT(ItemStack value) {
            return value.func_77955_b(new NBTTagCompound());
        }

        @Override
        public ItemStack fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagCompound.class, ItemStack::new);
        }
    }

    public static class StringAdapter
    extends AbstractNBTTypeAdapter<String, NBTTagString> {
        @Override
        public NBTTagString toNBT(String value) {
            return new NBTTagString(value);
        }

        @Override
        public String fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagString.class, NBTTagString::func_150285_a_);
        }
    }

    public static class BooleanAdapter
    extends AbstractNBTTypeAdapter<Boolean, NBTTagByte> {
        @Override
        public NBTTagByte toNBT(Boolean value) {
            return new NBTTagByte((byte)(value != false ? 1 : 0));
        }

        @Override
        public Boolean fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagByte.class, tag -> tag.func_150290_f() == 1);
        }
    }

    public static class ByteAdapter
    extends AbstractNBTTypeAdapter<Byte, NBTTagByte> {
        @Override
        public NBTTagByte toNBT(Byte value) {
            return new NBTTagByte(value.byteValue());
        }

        @Override
        public Byte fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagByte.class, NBTTagByte::func_150290_f);
        }
    }

    public static class ShortAdapter
    extends AbstractNBTTypeAdapter<Short, NBTTagShort> {
        @Override
        public NBTTagShort toNBT(Short value) {
            return new NBTTagShort(value.shortValue());
        }

        @Override
        public Short fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagShort.class, NBTTagShort::func_150289_e);
        }
    }

    public static class LongAdapter
    extends AbstractNBTTypeAdapter<Long, NBTTagLong> {
        @Override
        public NBTTagLong toNBT(Long value) {
            return new NBTTagLong(value.longValue());
        }

        @Override
        public Long fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagLong.class, NBTTagLong::func_150291_c);
        }
    }

    public static class FloatAdapter
    extends AbstractNBTTypeAdapter<Float, NBTTagFloat> {
        @Override
        public NBTTagFloat toNBT(Float value) {
            return new NBTTagFloat(value.floatValue());
        }

        @Override
        public Float fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagFloat.class, NBTTagFloat::func_150288_h);
        }
    }

    public static class DoubleAdapter
    extends AbstractNBTTypeAdapter<Double, NBTTagDouble> {
        @Override
        public NBTTagDouble toNBT(Double value) {
            return new NBTTagDouble(value.doubleValue());
        }

        @Override
        public Double fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagDouble.class, NBTTagDouble::func_150286_g);
        }
    }

    public static class IntAdapter
    extends AbstractNBTTypeAdapter<Integer, NBTTagInt> {
        @Override
        public NBTTagInt toNBT(Integer value) {
            return new NBTTagInt(value.intValue());
        }

        @Override
        public Integer fromNBT(NBTBase nbt) {
            return this.castAnd(nbt, NBTTagInt.class, NBTTagInt::func_150287_d);
        }
    }
}

