/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import ladylib.nbt.NBTDeserializationException;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.TagAdapters;
import net.minecraft.nbt.NBTBase;
import org.jetbrains.annotations.Contract;

public abstract class AbstractNBTTypeAdapter<T, NBT extends NBTBase>
implements NBTTypeAdapter<T, NBT> {
    protected final TypeToken<T> typeToken;

    protected AbstractNBTTypeAdapter() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing specific type parameter. Use the explicit constructor instead.");
        }
        Type superclassType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.typeToken = TypeToken.get((Type)superclassType);
    }

    protected AbstractNBTTypeAdapter(TypeToken<T> typeToken) {
        this.typeToken = typeToken;
    }

    @Contract(pure=true)
    protected Optional<NBT> cast(NBTBase nbt, Class<NBT> clazz) {
        return NBTTypeAdapter.castNBT(nbt, clazz);
    }

    protected T castAnd(NBTBase nbt, Class<NBT> clazz, Function<NBT, T> conversion) {
        return (T)this.cast(nbt, clazz).map(conversion).orElseGet(() -> TagAdapters.getDefaultValue(this.typeToken).orElseThrow(() -> new NBTDeserializationException("Expected an instance of " + clazz.getName() + " but " + nbt + " is of type " + nbt.getClass().getName())));
    }
}

