/*
 * Decompiled with CFR 0.152.
 */
package ladylib.client.shader;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.client.shader.ShaderRegistryEvent;
import ladylib.misc.MatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class ShaderUtil {
    private static int prevProgram = 0;
    private static int currentProgram = 0;
    static final String SHADER_LOCATION_PREFIX = "shaders/";
    private static final Map<ResourceLocation, ShaderGroup> screenShaders = new HashMap<ResourceLocation, ShaderGroup>();
    private static boolean resetScreenShaders;
    private static int oldDisplayWidth;
    private static int oldDisplayHeight;
    private static final Object2IntMap<ResourceLocation> linkedShaders;
    private static boolean initialized;

    private static boolean shouldUseShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.func_71410_x();
            ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a(ShaderUtil::loadShaders);
            initialized = true;
        }
    }

    public static void useShader(ResourceLocation id) {
        ShaderUtil.useShader(linkedShaders.getInt((Object)id));
    }

    public static void useShader(int program) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        prevProgram = GlStateManager.func_187397_v((int)35725);
        OpenGlHelper.func_153161_d((int)program);
        currentProgram = program;
    }

    public static void setUniform(String uniformName, int value) {
        if (!ShaderUtil.shouldUseShaders() || currentProgram == 0) {
            return;
        }
        int uniform = GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniformName);
        if (uniform != -1) {
            GL20.glUniform1i((int)uniform, (int)value);
        }
    }

    public static void setUniform(String uniformName, float ... values) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        int uniform = GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniformName);
        if (uniform != -1) {
            switch (values.length) {
                case 1: {
                    GL20.glUniform1f((int)uniform, (float)values[0]);
                    break;
                }
                case 2: {
                    GL20.glUniform2f((int)uniform, (float)values[0], (float)values[1]);
                    break;
                }
                case 3: {
                    GL20.glUniform3f((int)uniform, (float)values[0], (float)values[1], (float)values[2]);
                    break;
                }
                case 4: {
                    GL20.glUniform4f((int)uniform, (float)values[0], (float)values[1], (float)values[2], (float)values[3]);
                }
            }
        }
    }

    public static void setUniform(String uniformName, FloatBuffer mat4) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        int uniform = GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniformName);
        if (uniform != -1) {
            GL20.glUniformMatrix4((int)uniform, (boolean)true, (FloatBuffer)mat4);
        }
    }

    public static void bindAdditionalTextures(ResourceLocation ... textures) {
        for (int i = 0; i < textures.length; ++i) {
            ResourceLocation texture = textures[i];
            GlStateManager.func_179138_g((int)(i + OpenGlHelper.field_77478_a + 2));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            ShaderUtil.setUniform("texture" + (i + 1), i + 2);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static FloatBuffer getProjectionMatrix() {
        FloatBuffer projection = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        projection.position(0);
        return projection;
    }

    public static FloatBuffer getProjectionMatrixInverse() {
        FloatBuffer projection = ShaderUtil.getProjectionMatrix();
        FloatBuffer projectionInverse = BufferUtils.createFloatBuffer((int)16);
        MatUtil.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0));
        projection.position(0);
        projectionInverse.position(0);
        return projectionInverse;
    }

    public static FloatBuffer getModelViewMatrix() {
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        modelView.position(0);
        return modelView;
    }

    public static FloatBuffer getModelViewMatrixInverse() {
        FloatBuffer modelView = ShaderUtil.getModelViewMatrix();
        FloatBuffer modelViewInverse = ByteBuffer.allocateDirect(64).asFloatBuffer();
        MatUtil.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0));
        modelView.position(0);
        modelViewInverse.position(0);
        return modelViewInverse;
    }

    public static void revert() {
        ShaderUtil.useShader(prevProgram);
    }

    public static void enableScreenShader(ResourceLocation location) {
        if (ShaderUtil.shouldUseShaders() && !screenShaders.containsKey(location)) {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                resetScreenShaders = true;
                screenShaders.put(location, new ShaderGroup(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), location));
            }
            catch (IOException e) {
                LadyLib.LOGGER.error((Message)new FormattedMessage("Could not enable screen shader {}", (Object)location), (Throwable)e);
            }
        }
    }

    public static void disableScreenShader(ResourceLocation location) {
        if (screenShaders.containsKey(location)) {
            screenShaders.remove(location).func_148021_a();
        }
    }

    @SubscribeEvent
    public static void renderScreenShaders(RenderGameOverlayEvent.Pre event) {
        if (ShaderUtil.shouldUseShaders() && !screenShaders.isEmpty() && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ShaderUtil.resetScreenShaders();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            for (ShaderGroup shaderGroup : screenShaders.values()) {
                GlStateManager.func_179094_E();
                ShaderUtil.setScreenUniform(shaderGroup);
                shaderGroup.func_148018_a(event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        }
    }

    public static void setScreenUniform(ShaderGroup shaderGroup) {
        for (Shader shader : shaderGroup.field_148031_d) {
            shader.func_148043_c().func_147984_b("SystemTime").func_148090_a((float)System.currentTimeMillis());
        }
    }

    private static void resetScreenShaders() {
        Minecraft mc = Minecraft.func_71410_x();
        if (resetScreenShaders || mc.field_71443_c != oldDisplayWidth || oldDisplayHeight != mc.field_71440_d) {
            for (ShaderGroup sg : screenShaders.values()) {
                sg.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            }
            oldDisplayWidth = mc.field_71443_c;
            oldDisplayHeight = mc.field_71440_d;
            resetScreenShaders = false;
        }
    }

    private static void loadShaders(IResourceManager resourceManager) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        HashMap<ResourceLocation, Pair<ResourceLocation, ResourceLocation>> registeredShaders = new HashMap<ResourceLocation, Pair<ResourceLocation, ResourceLocation>>();
        MinecraftForge.EVENT_BUS.post((Event)new ShaderRegistryEvent(registeredShaders));
        registeredShaders.forEach((rl, sh) -> linkedShaders.put(rl, ShaderUtil.loadShader(resourceManager, (ResourceLocation)sh.getLeft(), (ResourceLocation)sh.getRight())));
    }

    private static int loadShader(IResourceManager resourceManager, @Nullable ResourceLocation vertexLocation, @Nullable ResourceLocation fragmentLocation) {
        int programId = OpenGlHelper.func_153183_d();
        int vertexShaderId = 0;
        int fragmentShaderId = 0;
        if (vertexLocation != null) {
            vertexShaderId = OpenGlHelper.func_153195_b((int)OpenGlHelper.field_153209_q);
            ARBShaderObjects.glShaderSourceARB((int)vertexShaderId, (CharSequence)ShaderUtil.fromFile(resourceManager, vertexLocation));
            OpenGlHelper.func_153170_c((int)vertexShaderId);
            OpenGlHelper.func_153178_b((int)programId, (int)vertexShaderId);
        }
        if (fragmentLocation != null) {
            fragmentShaderId = OpenGlHelper.func_153195_b((int)OpenGlHelper.field_153210_r);
            ARBShaderObjects.glShaderSourceARB((int)fragmentShaderId, (CharSequence)ShaderUtil.fromFile(resourceManager, fragmentLocation));
            OpenGlHelper.func_153170_c((int)fragmentShaderId);
            OpenGlHelper.func_153178_b((int)programId, (int)fragmentShaderId);
        }
        OpenGlHelper.func_153179_f((int)programId);
        if (OpenGlHelper.func_153175_a((int)programId, (int)35714) == 0) {
            throw new RuntimeException("Error linking Shader code: " + OpenGlHelper.func_153166_e((int)programId, (int)1024));
        }
        if (vertexShaderId != 0) {
            GL20.glDetachShader((int)programId, (int)vertexShaderId);
        }
        if (fragmentShaderId != 0) {
            GL20.glDetachShader((int)programId, (int)fragmentShaderId);
        }
        if (LadyLib.isDevEnv()) {
            GL20.glValidateProgram((int)programId);
            if (OpenGlHelper.func_153175_a((int)programId, (int)35715) == 0) {
                System.err.println("Warning validating Shader code:" + OpenGlHelper.func_153166_e((int)programId, (int)1024));
            }
        }
        return programId;
    }

    private static String fromFile(IResourceManager resourceManager, ResourceLocation fileLocation) {
        StringBuilder source = new StringBuilder();
        try (InputStream in = resourceManager.func_110536_a(fileLocation).func_110527_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                source.append(line).append('\n');
            }
        }
        catch (IOException exc) {
            LadyLib.LOGGER.error((Object)exc);
        }
        catch (NullPointerException e) {
            LadyLib.LOGGER.error(e + " : " + fileLocation + " does not exist");
        }
        return source.toString();
    }

    static {
        oldDisplayWidth = Minecraft.func_71410_x().field_71443_c;
        oldDisplayHeight = Minecraft.func_71410_x().field_71440_d;
        linkedShaders = new Object2IntOpenHashMap();
        initialized = false;
    }
}

