/*
 * Decompiled with CFR 0.152.
 */
package ladylib.capability.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import ladylib.LadyLib;
import ladylib.capability.AutoCapability;
import ladylib.capability.ReflectiveCapabilityStorage;
import ladylib.capability.internal.CapabilityEventHandler;
import ladylib.misc.ReflectionUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class CapabilityRegistrar {
    public <T> void findCapabilityImplementations(ASMDataTable asmData) {
        Set allRegistryHandlers = asmData.getAll(AutoCapability.class.getName());
        CapabilityEventHandler handler = new CapabilityEventHandler();
        try {
            Field providersField = CapabilityManager.class.getDeclaredField("providers");
            providersField.setAccessible(true);
            Map providers = (Map)providersField.get(CapabilityManager.INSTANCE);
            for (ASMDataTable.ASMData data : allRegistryHandlers) {
                String className = data.getClassName();
                Map annotationInfo = data.getAnnotationInfo();
                org.objectweb.asm.Type implName = (org.objectweb.asm.Type)annotationInfo.get("value");
                try {
                    Class<?> impl;
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = Class.forName(className, false, classLoader);
                    Class<?> clazz2 = impl = implName.getSort() == 10 ? Class.forName(implName.getClassName(), false, classLoader) : clazz;
                    if (!clazz.isAssignableFrom(impl)) {
                        throw new IllegalArgumentException("The given implementation " + impl + " does not implement the capability " + clazz);
                    }
                    Capability.IStorage<?> storage = this.createStorage(impl, (org.objectweb.asm.Type)annotationInfo.get("storage"));
                    this.createRegisterCapability(clazz, impl, storage, handler, providers);
                }
                catch (ClassNotFoundException | IllegalArgumentException | InstantiationException | ReflectionUtil.UnableToGetFactoryException e) {
                    LadyLib.LOGGER.error((Message)new FormattedMessage("Could not register a capability for the class {}", (Object)className), (Throwable)e);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LadyLib.LOGGER.fatal("Unable to process capabilities", (Throwable)e);
        }
    }

    private <T> void createRegisterCapability(Class<T> clazz, Class<? extends T> implementation, Capability.IStorage<T> storage, CapabilityEventHandler handler, Map<String, Capability<?>> providers) {
        Callable factory = (Callable)ReflectionUtil.createFactory(implementation, "call", Callable.class);
        CapabilityManager.INSTANCE.register(clazz, storage, factory);
        Capability<?> capability = providers.get(implementation.getName().intern());
        this.addAttachHandlers(capability, clazz, factory, handler);
    }

    private <T> Capability.IStorage<T> createStorage(Class<? extends T> impl, org.objectweb.asm.Type storage) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(storage.getClassName());
        if (!Capability.IStorage.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Invalid annotation info, " + storage + " is not a valid storage type");
        }
        if (clazz == Capability.IStorage.class) {
            return new ReflectiveCapabilityStorage<T>(impl);
        }
        return (Capability.IStorage)clazz.newInstance();
    }

    private <T> void addAttachHandlers(Capability<T> capability, Class<T> capClass, Callable<? extends T> factory, CapabilityEventHandler handler) {
        boolean attached = false;
        for (Method method : capClass.getMethods()) {
            AutoCapability.AttachCapabilityCheckHandler checker = method.getAnnotation(AutoCapability.AttachCapabilityCheckHandler.class);
            if (checker == null) continue;
            ResourceLocation key = new ResourceLocation(checker.value());
            if (!Modifier.isStatic(method.getModifiers())) {
                this.logBadSignature(method, " Such methods should be static.");
                continue;
            }
            if (method.getParameterTypes().length > 0) {
                this.logBadSignature(method, "Such methods should not have any parameter.");
                continue;
            }
            Type retType = method.getGenericReturnType();
            if (!(retType instanceof ParameterizedType) || !Predicate.class.isAssignableFrom(method.getReturnType())) {
                this.logBadSignature(method, "Such methods should have a generic return value implementing Predicate.");
                continue;
            }
            Type retParamType = ((ParameterizedType)retType).getActualTypeArguments()[0];
            if (retParamType instanceof Class) {
                Predicate predicate;
                Class retClass = (Class)retParamType;
                try {
                    predicate = (Predicate)method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LadyLib.LOGGER.error("Error while calling AttachCapabilityCheckHandler method", (Throwable)e);
                    continue;
                }
                CapabilityEventHandler.ProviderInfo info = new CapabilityEventHandler.ProviderInfo(key, predicate, capability, factory);
                attached = true;
                if (Entity.class.isAssignableFrom(retClass)) {
                    this.addProvider(info, handler.entityProviders);
                    continue;
                }
                if (ItemStack.class.isAssignableFrom(retClass)) {
                    this.addProvider(info, handler.itemProviders);
                    continue;
                }
                if (TileEntity.class.isAssignableFrom(retClass)) {
                    this.addProvider(info, handler.teProviders);
                    continue;
                }
            }
            this.logBadSignature(method, "The returned predicate should have a generic type of either Entity, ItemStack or TileEntity.");
        }
        if (attached) {
            MinecraftForge.EVENT_BUS.register((Object)handler);
        }
    }

    private void addProvider(CapabilityEventHandler.ProviderInfo info, List list) {
        list.add(info);
    }

    private void logBadSignature(Method method, String s) {
        LadyLib.LOGGER.error("Found unexpected method signature {} for annotation AttachCapabilityCheckHandler.", (Object)method);
    }
}

