/*
 * Decompiled with CFR 0.152.
 */
package ladylib;

import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import com.google.gson.reflect.TypeToken;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.LLibContainer;
import ladylib.client.ClientHandler;
import ladylib.client.particle.LLParticleManager;
import ladylib.nbt.NBTDeserializationException;
import ladylib.nbt.NBTTypeAdapter;
import ladylib.nbt.TagAdapters;
import ladylib.nbt.internal.DefaultValuesSearch;
import ladylib.registration.BlockRegistrar;
import ladylib.registration.ItemRegistrar;
import ladylib.registration.internal.AutoRegistrar;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.TracingPrintStream;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ladylib", name="LadyLib", version="2.1", dependencies="before:all", acceptedMinecraftVersions="[1.12.2]")
public class LadyLib {
    public static final String MOD_ID = "ladylib";
    public static final String MOD_NAME = "LadyLib";
    public static final String VERSION = "2.1";
    public static final Logger LOGGER = LogManager.getLogger((String)"LadyLib");
    private static final PrintStream DEBUG_STREAM = new TracingPrintStream(LogManager.getLogger((String)"DEBUG"), System.out);
    private static final Map<String, LLibContainer> allInstances = new HashMap<String, LLibContainer>();
    @Mod.Instance
    public static LadyLib instance;
    private AutoRegistrar registrar;
    @SideOnly(value=Side.CLIENT)
    private ClientHandler clientHandler;

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static void debug(Object message) {
        if (LadyLib.isDevEnv()) {
            DEBUG_STREAM.println(message);
        }
    }

    @Nullable
    public static NBTBase toNBT(@Nullable Object src) {
        return src == null ? null : LadyLib.toNBT(src, src.getClass());
    }

    @Nullable
    public static NBTBase toNBT(Object src, Type typeOfSrc) {
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get((Type)typeOfSrc), false);
        return adapter.toNBT(src);
    }

    @Nullable
    public static <T> T fromNBT(@Nullable NBTBase nbt, Class<T> classOfT) throws NBTDeserializationException {
        return LadyLib.fromNBT(nbt, classOfT);
    }

    @Nullable
    public static <T> T fromNBT(@Nullable NBTBase nbt, Type typeOfT) throws NBTDeserializationException {
        if (nbt == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)typeOfT);
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get((Type)typeOfT), false);
        return adapter.fromNBT(nbt);
    }

    @Nullable
    public static NBTBase serializeNBT(@Nonnull Object src) {
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get(src.getClass()), true);
        return adapter.toNBT(src);
    }

    public static void deserializeNBT(@Nonnull Object target, @Nullable NBTBase nbt) throws NBTDeserializationException {
        if (nbt == null) {
            return;
        }
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get(target.getClass()), true);
        adapter.fromNBT(target, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public static LLParticleManager getParticleManager() {
        return LadyLib.instance.clientHandler.getParticleManager();
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        ASMDataTable dataTable = event.getAsmData();
        this.registrar = new AutoRegistrar(dataTable);
        MinecraftForge.EVENT_BUS.register((Object)this.registrar);
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getItemRegistrar());
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getBlockRegistrar());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.clientHandler = new ClientHandler();
            this.clientHandler.clientInit();
        }
        this.registrar.autoRegisterTileEntities(dataTable);
        this.injectContainers(dataTable);
        DefaultValuesSearch.searchDefaultValues(dataTable);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
    }

    private void injectContainers(ASMDataTable asmData) {
        try {
            Method parseSimpleFieldAnnotation = FMLModContainer.class.getDeclaredMethod("parseSimpleFieldAnnotation", SetMultimap.class, String.class, Function.class);
            parseSimpleFieldAnnotation.setAccessible(true);
            for (ModContainer container : Loader.instance().getModList()) {
                SetMultimap annotations = asmData.getAnnotationsFor(container);
                if (!(container instanceof FMLModContainer)) continue;
                parseSimpleFieldAnnotation.invoke((Object)container, annotations, LLInstance.class.getName(), mc -> this.getContainer(mc.getModId()));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<LLibContainer> getAllInstances() {
        return allInstances.values();
    }

    public LLibContainer getContainer(String modid) {
        return allInstances.computeIfAbsent(modid, id -> new LLibContainer((ModContainer)Loader.instance().getIndexedModList().get(id)));
    }

    public ItemRegistrar getItemRegistrar() {
        return this.registrar.getItemRegistrar();
    }

    public BlockRegistrar getBlockRegistrar() {
        return this.registrar.getBlockRegistrar();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LLInstance {
        public String value() default "";

        public String owner() default "";
    }
}

