/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonASMHelper;

public class RandomUpdateHandler {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        block16: {
            Season season;
            Season.SubSeason subSeason;
            block17: {
                if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) break block16;
                subSeason = SeasonHelper.getSeasonState(event.world).getSubSeason();
                season = subSeason.getSeason();
                if (season != Season.WINTER) break block17;
                if (!ModConfig.seasons.changeWeatherFrequency) break block16;
                if (event.world.func_72912_H().func_76061_m()) {
                    event.world.func_72912_H().func_76069_a(false);
                }
                if (event.world.func_72912_H().func_76059_o() || event.world.func_72912_H().func_76083_p() <= 36000) break block16;
                event.world.func_72912_H().func_76080_g(event.world.field_73012_v.nextInt(24000) + 12000);
                break block16;
            }
            if (ModConfig.seasons.changeWeatherFrequency) {
                if (season == Season.SPRING) {
                    if (!event.world.func_72912_H().func_76059_o() && event.world.func_72912_H().func_76083_p() > 96000) {
                        event.world.func_72912_H().func_76080_g(event.world.field_73012_v.nextInt(84000) + 12000);
                    }
                } else if (season == Season.SUMMER && !event.world.func_72912_H().func_76061_m() && event.world.func_72912_H().func_76071_n() > 36000) {
                    event.world.func_72912_H().func_76090_f(event.world.field_73012_v.nextInt(24000) + 12000);
                }
            }
            if (ModConfig.seasons.generateSnowAndIce && SeasonsConfig.isDimensionWhitelisted(event.world.field_73011_w.getDimension())) {
                WorldServer world = (WorldServer)event.world;
                Iterator iterator = world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
                block5: while (iterator.hasNext()) {
                    int rand;
                    Chunk chunk = (Chunk)iterator.next();
                    int x = chunk.field_76635_g << 4;
                    int z = chunk.field_76647_h << 4;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            rand = 16;
                            break;
                        }
                        case MID_SPRING: {
                            rand = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            rand = 8;
                            break;
                        }
                        default: {
                            rand = 4;
                        }
                    }
                    if (world.field_73012_v.nextInt(rand) != 0) continue;
                    world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                    int randOffset = world.field_73005_l >> 2;
                    BlockPos pos = world.func_175725_q(new BlockPos(x + (randOffset & 0xF), 0, z + (randOffset >> 8 & 0xF)));
                    Biome biome = world.func_180494_b(pos);
                    if (!BiomeConfig.enablesSeasonalEffects(biome)) continue;
                    boolean first = true;
                    for (int y = pos.func_177956_o(); y >= 0; --y) {
                        Block block = chunk.func_186032_a(pos.func_177958_n(), y, pos.func_177952_p()).func_177230_c();
                        if (block == Blocks.field_150431_aC && SeasonASMHelper.getFloatTemperature((World)world, biome, pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())) >= 0.15f) {
                            world.func_175698_g(pos);
                            continue block5;
                        }
                        if (!first) {
                            if (block != Blocks.field_150432_aD || !(SeasonASMHelper.getFloatTemperature((World)world, biome, pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())) >= 0.15f)) continue;
                            ((BlockIce)Blocks.field_150432_aD).func_185679_b((World)world, pos);
                            continue block5;
                        }
                        first = false;
                    }
                }
            }
        }
    }
}

