/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.asm.transformer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import sereneseasons.asm.ASMHelper;
import sereneseasons.asm.ObfHelper;

public class EntityRendererTransformer
implements IClassTransformer {
    private static final String[] RENDER_RAIN_SNOW_NAMES = new String[]{"renderRainSnow", "func_78474_d", "c"};
    private static final String[] ADD_RAIN_PARTICLES_NAMES = new String[]{"addRainParticles", "func_78484_h", "q"};
    private static final String[] GET_FLOAT_TEMPERATURE_NAMES = new String[]{"getTemperature", "func_180626_a", "a"};
    private static final String[] CAN_RAIN_NAMES = new String[]{"canRain", "func_76738_d", "d"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.transformEntityRenderer(basicClass, !transformedName.equals(name));
        }
        return basicClass;
    }

    private byte[] transformEntityRenderer(byte[] bytes, boolean obfuscatedClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        ArrayList successfulTransformations = Lists.newArrayList();
        for (MethodNode methodNode : classNode.methods) {
            int successCount;
            if (ASMHelper.methodEquals(methodNode, RENDER_RAIN_SNOW_NAMES, "(F)V")) {
                int targetInsnIndex;
                successCount = 0;
                int worldVarNum = -1;
                MethodInsnNode targetMethodInsnNode = ASMHelper.getUniqueMethodInsnNode(methodNode, 182, ObfHelper.unmapType(obfuscatedClass, "net/minecraft/world/biome/Biome"), CAN_RAIN_NAMES, ObfHelper.createMethodDescriptor(obfuscatedClass, "Z", new String[0]));
                if (targetMethodInsnNode != null) {
                    targetInsnIndex = methodNode.instructions.indexOf((AbstractInsnNode)targetMethodInsnNode);
                    int worldAloadIndex = targetInsnIndex - 7;
                    if (!(methodNode.instructions.get(worldAloadIndex) instanceof VarInsnNode)) {
                        throw new RuntimeException("Failed to locate world var number whilst replacing biome.canRain() || biome.getEnableSnow()");
                    }
                    worldVarNum = ((VarInsnNode)methodNode.instructions.get((int)worldAloadIndex)).var;
                    targetMethodInsnNode.setOpcode(184);
                    targetMethodInsnNode.owner = "sereneseasons/season/SeasonASMHelper";
                    targetMethodInsnNode.name = "shouldRenderRainSnow";
                    targetMethodInsnNode.desc = ObfHelper.createMethodDescriptor(obfuscatedClass, "Z", "net/minecraft/world/World", "net/minecraft/world/biome/Biome");
                    ASMHelper.clearNextInstructions(methodNode, methodNode.instructions.get(targetInsnIndex + 1), 3);
                    methodNode.instructions.insertBefore(methodNode.instructions.get(targetInsnIndex - 1), (AbstractInsnNode)new VarInsnNode(25, worldVarNum));
                    int offset = 0;
                    AbstractInsnNode currentInsn = methodNode.instructions.get(--targetInsnIndex - offset);
                    do {
                        if (!(currentInsn instanceof VarInsnNode)) {
                            methodNode.instructions.remove(currentInsn);
                            continue;
                        }
                        VarInsnNode varInsnNode = (VarInsnNode)currentInsn;
                        if (varInsnNode.getOpcode() == 25 && varInsnNode.var != 5 && varInsnNode.var != 29) {
                            methodNode.instructions.remove(currentInsn);
                            continue;
                        }
                        ++offset;
                    } while (!((currentInsn = methodNode.instructions.get(targetInsnIndex - offset)) instanceof LabelNode));
                    ++successCount;
                }
                if ((targetMethodInsnNode = ASMHelper.getUniqueMethodInsnNode(methodNode, 182, ObfHelper.unmapType(obfuscatedClass, "net/minecraft/world/biome/Biome"), GET_FLOAT_TEMPERATURE_NAMES, ObfHelper.createMethodDescriptor(obfuscatedClass, "F", "net/minecraft/util/math/BlockPos"))) != null) {
                    targetInsnIndex = methodNode.instructions.indexOf((AbstractInsnNode)targetMethodInsnNode);
                    targetMethodInsnNode.setOpcode(184);
                    targetMethodInsnNode.owner = "sereneseasons/season/SeasonASMHelper";
                    targetMethodInsnNode.name = "getFloatTemperature";
                    targetMethodInsnNode.desc = ObfHelper.createMethodDescriptor(obfuscatedClass, "F", "net/minecraft/world/World", "net/minecraft/world/biome/Biome", "net/minecraft/util/math/BlockPos");
                    methodNode.instructions.insertBefore(methodNode.instructions.get(targetInsnIndex - 2), (AbstractInsnNode)new VarInsnNode(25, worldVarNum));
                    ++successCount;
                }
                if (successCount != 2) continue;
                successfulTransformations.add(methodNode.name + " " + methodNode.desc);
                continue;
            }
            if (!ASMHelper.methodEquals(methodNode, ADD_RAIN_PARTICLES_NAMES, "()V")) continue;
            successCount = 0;
            MethodInsnNode targetMethodInsnNode = ASMHelper.getUniqueMethodInsnNode(methodNode, 182, ObfHelper.unmapType(obfuscatedClass, "net/minecraft/world/biome/Biome"), CAN_RAIN_NAMES, ObfHelper.createMethodDescriptor(obfuscatedClass, "Z", new String[0]));
            if (targetMethodInsnNode != null) {
                int targetInsnIndex = methodNode.instructions.indexOf((AbstractInsnNode)targetMethodInsnNode);
                targetMethodInsnNode.setOpcode(184);
                targetMethodInsnNode.owner = "sereneseasons/season/SeasonASMHelper";
                targetMethodInsnNode.name = "shouldAddRainParticles";
                targetMethodInsnNode.desc = ObfHelper.createMethodDescriptor(obfuscatedClass, "Z", "net/minecraft/world/World", "net/minecraft/world/biome/Biome");
                methodNode.instructions.insertBefore(methodNode.instructions.get(targetInsnIndex - 1), (AbstractInsnNode)new VarInsnNode(25, 3));
                ++successCount;
            }
            if ((targetMethodInsnNode = ASMHelper.getUniqueMethodInsnNode(methodNode, 182, ObfHelper.unmapType(obfuscatedClass, "net/minecraft/world/biome/Biome"), GET_FLOAT_TEMPERATURE_NAMES, ObfHelper.createMethodDescriptor(obfuscatedClass, "F", "net/minecraft/util/math/BlockPos"))) != null) {
                int targetInsnIndex = methodNode.instructions.indexOf((AbstractInsnNode)targetMethodInsnNode);
                targetMethodInsnNode.setOpcode(184);
                targetMethodInsnNode.owner = "sereneseasons/season/SeasonASMHelper";
                targetMethodInsnNode.name = "getFloatTemperature";
                targetMethodInsnNode.desc = ObfHelper.createMethodDescriptor(obfuscatedClass, "F", "net/minecraft/world/World", "net/minecraft/world/biome/Biome", "net/minecraft/util/math/BlockPos");
                methodNode.instructions.insertBefore(methodNode.instructions.get(targetInsnIndex - 2), (AbstractInsnNode)new VarInsnNode(25, 3));
                ++successCount;
            }
            if (successCount != 2) continue;
            successfulTransformations.add(methodNode.name + " " + methodNode.desc);
        }
        if (successfulTransformations.size() != 2) {
            throw new RuntimeException("An error occurred transforming EntityRenderer. Applied transformations: " + ((Object)successfulTransformations).toString());
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        bytes = writer.toByteArray();
        return bytes;
    }
}

